/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.spell.ISpellEffect;
import hellfirepvp.astralsorcery.common.constellation.spell.SpellEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public interface IConstellation {
    public static final Color major = new Color(40, 67, 204);
    public static final Color weak = new Color(67, 44, 176);
    public static final Color minor = new Color(93, 25, 127);

    public StarLocation addStar(int var1, int var2);

    public StarConnection addConnection(StarLocation var1, StarLocation var2);

    public List<StarLocation> getStars();

    public List<StarConnection> getStarConnections();

    public String getUnlocalizedName();

    default public String getUnlocalizedInfo() {
        return this.getUnlocalizedName() + ".info";
    }

    public static String getDefaultSaveKey() {
        return "constellationName";
    }

    public Color getConstellationColor();

    default public Color getTierRenderColor() {
        if (this instanceof IMinorConstellation) {
            return minor;
        }
        if (this instanceof IMajorConstellation) {
            return major;
        }
        return weak;
    }

    @Nullable
    default public ISpellEffect getSpellEffect() {
        return SpellEffectRegistry.getSpellEffect(this);
    }

    default public boolean canDiscover(PlayerProgress progress) {
        return true;
    }

    default public void writeToNBT(NBTTagCompound compound) {
        this.writeToNBT(compound, IConstellation.getDefaultSaveKey());
    }

    default public void writeToNBT(NBTTagCompound compound, String key) {
        compound.func_74778_a(key, this.getUnlocalizedName());
    }

    @Nullable
    public static IConstellation readFromNBT(NBTTagCompound compound) {
        return IConstellation.readFromNBT(compound, IConstellation.getDefaultSaveKey());
    }

    @Nullable
    public static IConstellation readFromNBT(NBTTagCompound compound, String key) {
        return ConstellationRegistry.getConstellationByName(compound.func_74779_i(key));
    }
}

