/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectAevitas;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectArmara;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectBootes;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectDiscidia;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectFornax;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectHorologium;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectLucerna;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectMineralis;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectOctans;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectVicio;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.event.APIRegistryEvent;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ConstellationEffectRegistry {
    private static Map<IWeakConstellation, ConstellationEffectProvider> providerMap = new HashMap<IWeakConstellation, ConstellationEffectProvider>();
    private static Map<IWeakConstellation, ConstellationEffect> singleRenderInstances = new HashMap<IWeakConstellation, ConstellationEffect>();

    public static void init() {
        ConstellationEffectRegistry.register(Constellations.aevitas, CEffectAevitas::new);
        ConstellationEffectRegistry.register(Constellations.discidia, CEffectDiscidia::new);
        ConstellationEffectRegistry.register(Constellations.armara, CEffectArmara::new);
        ConstellationEffectRegistry.register(Constellations.vicio, CEffectVicio::new);
        ConstellationEffectRegistry.register(Constellations.mineralis, CEffectMineralis::new);
        ConstellationEffectRegistry.register(Constellations.lucerna, CEffectLucerna::new);
        ConstellationEffectRegistry.register(Constellations.bootes, CEffectBootes::new);
        ConstellationEffectRegistry.register(Constellations.horologium, CEffectHorologium::new);
        ConstellationEffectRegistry.register(Constellations.octans, CEffectOctans::new);
        ConstellationEffectRegistry.register(Constellations.fornax, CEffectFornax::new);
        MinecraftForge.EVENT_BUS.post((Event)new APIRegistryEvent.ConstellationEffectRegister());
    }

    public static void addDynamicConfigEntries() {
        Config.addDynamicEntry(new CEffectAevitas());
        Config.addDynamicEntry(new CEffectDiscidia());
        Config.addDynamicEntry(new CEffectArmara());
        Config.addDynamicEntry(new CEffectVicio());
        Config.addDynamicEntry(new CEffectHorologium());
        Config.addDynamicEntry(new CEffectMineralis());
        Config.addDynamicEntry(new CEffectLucerna());
        Config.addDynamicEntry(new CEffectBootes());
        Config.addDynamicEntry(new CEffectOctans());
        Config.addDynamicEntry(new CEffectFornax());
    }

    private static void register(IWeakConstellation c, ConstellationEffectProvider provider) {
        providerMap.put(c, provider);
        singleRenderInstances.put(c, provider.provideEffectInstance());
    }

    public static void registerFromAPI(IWeakConstellation c, Function<Void, ConstellationEffect> providerFunc) {
        providerMap.put(c, new APIConstellationProvider(providerFunc));
        singleRenderInstances.put(c, providerFunc.apply(null));
    }

    @Nullable
    public static ConstellationEffect clientRenderInstance(IWeakConstellation c) {
        return singleRenderInstances.get(c);
    }

    @Nullable
    public static ConstellationEffect getEffect(IWeakConstellation c) {
        ConstellationEffectProvider p = providerMap.get(c);
        if (p != null) {
            return p.provideEffectInstance();
        }
        return null;
    }

    public static class APIConstellationProvider
    implements ConstellationEffectProvider {
        private final Function<Void, ConstellationEffect> providerFunc;

        public APIConstellationProvider(Function<Void, ConstellationEffect> providerFunc) {
            this.providerFunc = providerFunc;
        }

        @Override
        public ConstellationEffect provideEffectInstance() {
            return this.providerFunc.apply(null);
        }
    }

    public static interface ConstellationEffectProvider {
        public ConstellationEffect provideEffectInstance();
    }
}

