/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.common.base.HerdableAnimal;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectEntityCollect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class CEffectBootes
extends CEffectEntityCollect<EntityLivingBase> {
    public static double herdChance = 0.05;
    public static double potencyMultiplier = 1.0;
    public static float herdingLuck = -5.0f;
    public static float dropChance = 0.01f;

    public CEffectBootes() {
        super(Constellations.bootes, "bootes", 12.0, EntityLivingBase.class, e -> HerdableAnimal.getHerdable(e) != null);
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        List entities = this.collectEntities(world, pos);
        if (!entities.isEmpty()) {
            for (EntityLivingBase e : entities) {
                HerdableAnimal<EntityLivingBase> herd = HerdableAnimal.getHerdable(e);
                if (herd == null || !((double)rand.nextFloat() < herdChance)) continue;
                List<ItemStack> drops = herd.getHerdingDropsTick(e, world, rand, herdingLuck);
                for (ItemStack stack : drops) {
                    if (!(rand.nextFloat() < dropChance)) continue;
                    ItemUtils.dropItemNaturally(world, e.field_70165_t, e.field_70163_u, e.field_70161_v, stack);
                }
            }
        }
        return false;
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        super.loadFromConfig(cfg);
        herdingLuck = cfg.getFloat(this.getKey() + "HerdLuck", this.getConfigurationSection(), -5.0f, -200.0f, 200.0f, "Set the 'luck' when herding an animal for drops or related");
        herdChance = cfg.getFloat(this.getKey() + "HerdChance", this.getConfigurationSection(), 0.05f, 0.0f, 1.0f, "Set the chance that an registered animal will be 'herded' if it is close to the ritual.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
        dropChance = cfg.getFloat(this.getKey() + "OverallDropChance", this.getConfigurationSection(), 0.01f, 0.0f, 1.0f, "Set the chance that a drop that has been found from the entity's loot table is actually dropped.");
    }
}

