/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionList;
import hellfirepvp.astralsorcery.common.constellation.effect.GenListEntries;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectMineralis
extends CEffectPositionList {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static int searchRange = 14;
    public static int maxCount = 2;

    public CEffectMineralis() {
        super(Constellations.mineralis, "mineralis", searchRange, maxCount, (world, pos) -> {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a)).equals((Object)BlockStone.EnumType.STONE);
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        if (rand.nextBoolean()) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)((float)pos.func_177958_n() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5, (double)((float)pos.func_177956_o() + rand.nextFloat() * 2.0f) + 0.5, (double)((float)pos.func_177952_p() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5);
            p.motion(0.0, 0.0, 0.0).gravity(-0.01);
            p.scale(0.45f).setColor(new Color(188, 188, 188)).setMaxAge(55);
        }
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        BlockPos sel;
        if (!enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        boolean changed = false;
        GenListEntries.SimpleBlockPosEntry entry = (GenListEntries.SimpleBlockPosEntry)this.getRandomElementByChance(rand);
        if (entry != null && MiscUtils.isChunkLoaded(world, new ChunkPos(sel = entry.getPos()))) {
            if (this.verifier.isValid(world, sel)) {
                ItemStack blockStack = OreTypes.getRandomOre(rand);
                if (rand.nextInt(200000) == 0) {
                    blockStack = new ItemStack((Block)BlocksAS.customOre, 1, BlockCustomOre.OreType.STARMETAL.ordinal());
                }
                if (!blockStack.func_190926_b()) {
                    world.func_175656_a(sel, Block.func_149634_a((Item)blockStack.func_77973_b()).func_176203_a(blockStack.func_77952_i()));
                }
            } else {
                this.removeElement(entry);
                changed = true;
            }
        }
        if (this.findNewPosition(world, pos)) {
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), 14, 1, 32, "Defines the radius (in blocks) in which the ritual will search for cleanStone to generate ores into.");
        maxCount = cfg.getInt(this.getKey() + "Count", this.getConfigurationSection(), 2, 1, 4000, "Defines the amount of block-positions the ritual can cache at max count");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

