/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerServer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ConstellationPerk
extends ConfigEntry {
    protected static final Random rand = new Random();
    private final String unlocName;
    private final String unlocInfo;
    private final List<Target> perkEffectTargets;
    private int id = -1;

    protected ConstellationPerk(String name, Target ... targets) {
        super(ConfigEntry.Section.PERKS, name);
        this.unlocName = "perk." + name;
        this.unlocInfo = this.unlocName + ".info";
        this.perkEffectTargets = Lists.newArrayList((Object[])targets);
    }

    void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getUnlocalizedName() {
        return this.unlocName;
    }

    public String getUnlocalizedDescription() {
        return this.unlocInfo;
    }

    public boolean mayExecute(Target target) {
        return this.perkEffectTargets.contains((Object)target);
    }

    @SideOnly(value=Side.CLIENT)
    public void addLocalizedDescription(List<String> tooltip) {
        tooltip.add(I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)this.getUnlocalizedDescription(), (Object[])new Object[0]));
    }

    public void onPlayerTick(EntityPlayer player, Side side) {
    }

    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        return dmgIn;
    }

    public float onEntityHurt(EntityPlayer hurt, DamageSource source, float dmgIn) {
        return dmgIn;
    }

    public void onEntityKnockback(EntityPlayer attacker, EntityLivingBase attacked) {
    }

    public void onEntityKilled(EntityPlayer attacker, EntityLivingBase killed) {
    }

    public void onTimeout(EntityPlayer player) {
    }

    public boolean hasConfigEntries() {
        return false;
    }

    public final boolean isCooldownActiveForPlayer(EntityPlayer player) {
        return EventHandlerServer.perkCooldowns.hasList(player) && EventHandlerServer.perkCooldowns.getOrCreateList(player).contains(this.getId());
    }

    public final void setCooldownActiveForPlayer(EntityPlayer player, int cooldownTicks) {
        EventHandlerServer.perkCooldowns.getOrCreateList(player).setOrAddTimeout(cooldownTicks, this.getId());
    }

    public final void forceSetCooldownForPlayer(EntityPlayer player, int cooldownTicks) {
        if (!EventHandlerServer.perkCooldowns.getOrCreateList(player).setTimeout(cooldownTicks, this.getId())) {
            this.setCooldownActiveForPlayer(player, cooldownTicks);
        }
    }

    public final int getActiveCooldownForPlayer(EntityPlayer player) {
        if (!EventHandlerServer.perkCooldowns.hasList(player)) {
            return -1;
        }
        return EventHandlerServer.perkCooldowns.getOrCreateList(player).getTimeout(this.getId());
    }

    public final void addAlignmentCharge(EntityPlayer player, double charge) {
        if (!player.func_130014_f_().field_72995_K) {
            ResearchManager.modifyAlignmentCharge(player, charge);
        }
    }

    @Override
    public String getConfigurationSection() {
        return super.getConfigurationSection() + "." + this.getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstellationPerk that = (ConstellationPerk)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static enum Target {
        ENTITY_ATTACK,
        ENTITY_KNOCKBACK,
        ENTITY_KILL,
        ENTITY_HURT,
        PLAYER_TICK;

    }
}

