/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;

public class PerkDamageOnKill
extends ConstellationPerk {
    private static float dmgMultiplier = 1.05f;
    private static int ticksDuration = 60;

    public PerkDamageOnKill() {
        super("DMG_KILL", ConstellationPerk.Target.ENTITY_ATTACK, ConstellationPerk.Target.ENTITY_KILL);
    }

    @Override
    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        if (this.isCooldownActiveForPlayer(attacker)) {
            this.addAlignmentCharge(attacker, 2.0);
            dmgIn *= dmgMultiplier;
        }
        return dmgIn;
    }

    @Override
    public void onEntityKilled(EntityPlayer attacker, EntityLivingBase killed) {
        this.setCooldownActiveForPlayer(attacker, ticksDuration);
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        dmgMultiplier = cfg.getFloat(this.getKey() + "DamageIncrease", this.getConfigurationSection(), 1.05f, 1.0f, 2.0f, "Sets the damage multiplier that is applied to entity damaged after knocked back if the player has this perk.");
        ticksDuration = cfg.getInt(this.getKey() + "KillDuration", this.getConfigurationSection(), 60, 1, 1000, "Sets the duration on how long the player gets additional damage on the mob when it was knocked back.");
    }
}

