/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;

public class PerkDefensiveCheatDeath
extends ConstellationPerk {
    public static float thresholdApplyPerkHealth = 4.0f;
    public static float thresholdApplyPerkDamage = 6.0f;
    public static int cooldownPotionApplication = 1000;
    public static int potionDuration = 600;
    public static int potionAmplifier = 0;

    public PerkDefensiveCheatDeath() {
        super("DEF_CHEATDEATH", ConstellationPerk.Target.ENTITY_HURT);
    }

    @Override
    public float onEntityHurt(EntityPlayer hurt, DamageSource source, float dmgIn) {
        if ((hurt.func_110143_aJ() <= thresholdApplyPerkHealth || dmgIn >= thresholdApplyPerkDamage) && !this.isCooldownActiveForPlayer(hurt)) {
            this.setCooldownActiveForPlayer(hurt, cooldownPotionApplication);
            hurt.func_70690_d(new PotionEffect((Potion)RegistryPotions.potionCheatDeath, potionDuration, potionAmplifier, true, false));
        }
        return dmgIn;
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        thresholdApplyPerkHealth = cfg.getFloat(this.getKey() + "ThresholdHealth", this.getConfigurationSection(), thresholdApplyPerkHealth, 0.0f, 20.0f, "If the player drops below this value of health, the potion effect will apply in case it isn't on cooldown.");
        thresholdApplyPerkDamage = cfg.getFloat(this.getKey() + "ThresholdDamage", this.getConfigurationSection(), thresholdApplyPerkDamage, 1.0f, 100.0f, "If the player takes damage equals/higher to the amount of damage configured here, the potion effect will apply in case it isn't on cooldown.");
        cooldownPotionApplication = cfg.getInt(this.getKey() + "CooldownPotion", this.getConfigurationSection(), cooldownPotionApplication, 1, Integer.MAX_VALUE, "Once the potion effect gets applied, it'll take at least this amount of ticks or a server restart until it can be re-applied by this perk");
        potionDuration = cfg.getInt(this.getKey() + "PotionDuration", this.getConfigurationSection(), potionDuration, 1, Integer.MAX_VALUE, "Once the potion effect gets applied by any of the triggers, this will be used as tick-duration of the potion effect.");
        potionAmplifier = cfg.getInt(this.getKey() + "PotionAmplifier", this.getConfigurationSection(), potionAmplifier, 0, 32, "Once the potion effect gets applied by any of the triggers, this will be used as amplifier of the potion effect.");
    }
}

