/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.spell;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.constellation.spell.SpellControllerEffect;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpellCastingManager
implements ITickHandler {
    public static final SpellCastingManager INSTANCE = new SpellCastingManager();
    private List<SpellControllerEffect> activeSpellController = Lists.newArrayList();

    private SpellCastingManager() {
    }

    void addNewSpell(SpellControllerEffect effect) {
        this.activeSpellController.add(effect);
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        Iterator<SpellControllerEffect> iterator = this.activeSpellController.iterator();
        while (iterator.hasNext()) {
            SpellControllerEffect spell = iterator.next();
            spell.onUpdate();
            if (!spell.isFinished()) continue;
            iterator.remove();
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "SpellCast-Controller Manager";
    }
}

