/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.spell;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.spell.ISpellComponent;
import hellfirepvp.astralsorcery.common.constellation.spell.ISpellEffect;
import hellfirepvp.astralsorcery.common.constellation.spell.SpellCastingManager;
import hellfirepvp.astralsorcery.common.constellation.spell.SpellProjectile;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleDataEvent;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class SpellControllerEffect
implements Iterable<ISpellEffect> {
    protected final EntityLivingBase caster;
    protected Queue<ISpellEffect> spellEffects = Lists.newLinkedList();
    protected List<ISpellComponent> activeComponents = Lists.newLinkedList();
    private boolean started = false;
    private boolean finished = false;

    protected SpellControllerEffect(EntityLivingBase caster) {
        this.caster = caster;
    }

    public final void addEffect(ISpellEffect component) {
        if (this.started) {
            return;
        }
        this.spellEffects.add(component);
    }

    public final void addComponent(ISpellComponent component) {
        this.activeComponents.add(component);
    }

    final void onUpdate() {
        if (this.caster.field_70128_L) {
            this.setFinished();
            return;
        }
        this.activeComponents.removeIf(component -> !component.isValid());
        this.activeComponents.stream().filter(ISpellComponent::requiresUpdatesFromController).forEach(ISpellComponent::onUpdateController);
        this.updateController();
    }

    @Override
    public final Iterator<ISpellEffect> iterator() {
        return this.spellEffects.iterator();
    }

    public final void castEffect() {
        if (this.started) {
            return;
        }
        this.started = true;
        SpellCastingManager.INSTANCE.addNewSpell(this);
        this.startCasting();
    }

    public void projectileImpact(SpellProjectile projectile, RayTraceResult result) {
        for (ISpellEffect effect : this) {
            effect.impact(projectile, result);
        }
    }

    protected void particle(PktParticleDataEvent.ParticleType type, Vector3 pos, double ... data) {
        PktParticleDataEvent pkt = new PktParticleDataEvent(type, pos.getX(), pos.getY(), pos.getZ(), data);
        PacketChannel.CHANNEL.sendToAllAround((IMessage)pkt, PacketChannel.pointFromPos(this.caster.func_130014_f_(), pos.toBlockPos(), 64.0));
    }

    public final void setFinished() {
        this.finished = true;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public abstract void startCasting();

    public abstract void updateController();
}

