/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.spell;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.spell.ISpellEffect;
import hellfirepvp.astralsorcery.common.constellation.spell.SpellControllerEffect;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;

public class SpellEffectRegistry {
    private static Map<IConstellation, ISpellEffect> spellEffectRegistry = new HashMap<IConstellation, ISpellEffect>();
    private static Map<IMajorConstellation, SpellControllerProvider> controllerEffectMap = new HashMap<IMajorConstellation, SpellControllerProvider>();

    @Nullable
    public static ISpellEffect getSpellEffect(IConstellation constellation) {
        return spellEffectRegistry.get(constellation);
    }

    @Nullable
    public static SpellControllerEffect createEmptySpell(IMajorConstellation constellation, EntityLivingBase caster) {
        SpellControllerProvider provider = controllerEffectMap.get(constellation);
        if (provider != null) {
            return provider.createEmptySpellFor(caster);
        }
        return null;
    }

    public static void registerControllerEffect(IMajorConstellation cst, SpellControllerProvider effect) {
        controllerEffectMap.put(cst, effect);
    }

    public static void registerSpellEffect(IConstellation cst, ISpellEffect effect) {
        spellEffectRegistry.put(cst, effect);
    }

    public static interface SpellControllerProvider {
        public SpellControllerEffect createEmptySpellFor(EntityLivingBase var1);
    }
}

