/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.spell;

import hellfirepvp.astralsorcery.common.constellation.spell.ISpellComponent;
import hellfirepvp.astralsorcery.common.constellation.spell.SpellControllerEffect;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpellProjectile
extends EntityThrowable
implements IProjectile,
ISpellComponent {
    private static final DataParameter<Integer> COLOR_TRAIL = EntityDataManager.func_187226_a(SpellProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR_SPARK = EntityDataManager.func_187226_a(SpellProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private int ticksNextSpellPulse = -1;
    private SpellControllerEffect spellController;

    public SpellProjectile(World worldIn) {
        super(worldIn);
    }

    public SpellProjectile(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public SpellProjectile(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public SpellProjectile(World worldIn, SpellControllerEffect controllerEffect) {
        super(worldIn, controllerEffect.caster);
        this.setSpellController(controllerEffect);
        float x = -MathHelper.func_76126_a((float)(controllerEffect.caster.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(controllerEffect.caster.field_70125_A * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(controllerEffect.caster.field_70125_A * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(controllerEffect.caster.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(controllerEffect.caster.field_70125_A * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, 2.5f, 4.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_TRAIL, (Object)-1);
        this.field_70180_af.func_187214_a(COLOR_SPARK, (Object)-1);
    }

    public void setSpellController(SpellControllerEffect spellController) {
        this.spellController = spellController;
    }

    public void scheduleNextSpellPulse(int ticks) {
        this.ticksNextSpellPulse = ticks;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            if (this.spellController == null) {
                this.func_70106_y();
                return;
            }
            --this.ticksNextSpellPulse;
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.spellController == null) {
                this.func_70106_y();
                return;
            }
            this.spellController.projectileImpact(this, result);
        }
    }

    @Override
    public void onUpdateController() {
        if (this.spellController == null) {
            this.func_70106_y();
            return;
        }
        this.spellController.forEach(c -> c.affectProjectile(this));
    }

    public void setColors(int colorTrail, int colorSparks) {
        this.field_70180_af.func_187227_b(COLOR_TRAIL, (Object)colorTrail);
        this.field_70180_af.func_187227_b(COLOR_SPARK, (Object)colorSparks);
    }

    public Color getColorTrail() {
        return new Color((Integer)this.field_70180_af.func_187225_a(COLOR_TRAIL));
    }

    public Color getColorSparks() {
        return new Color((Integer)this.field_70180_af.func_187225_a(COLOR_SPARK));
    }

    @Override
    public boolean isValid() {
        return !this.field_70128_L && !this.field_70122_E;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    @Override
    @Nullable
    public SpellControllerEffect getSpellController() {
        return this.spellController;
    }

    @Override
    public ISpellComponent copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189511_e(tag);
        tag.func_82580_o("UUIDMost");
        tag.func_82580_o("UUIDLeast");
        Entity e = EntityList.func_191304_a(this.getClass(), (World)this.field_70170_p);
        if (e == null) {
            throw new IllegalStateException("Unknown or unregistered entity with class: " + this.getClass().getName());
        }
        if (!(e instanceof ISpellComponent)) {
            throw new IllegalStateException("Entity is not a ISpellComponent: " + this.getClass().getName());
        }
        e.func_70020_e(tag);
        return (ISpellComponent)e;
    }
}

