/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.spell.plague;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.spell.ISpellEffect;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlagueEffect {
    private IConstellation parent;
    private int ticksApplied = 0;
    private int duration;
    private boolean expired = false;

    public PlagueEffect(IConstellation parentConstellation, int expectedDuration) {
        this.parent = parentConstellation;
        this.duration = expectedDuration;
    }

    public PlagueEffect(NBTTagCompound compound) {
        this.readNBT(compound);
    }

    public void onTick(EntityLivingBase affected) {
        if (this.hasExpired()) {
            return;
        }
        ISpellEffect effect = this.parent.getSpellEffect();
        if (effect == null) {
            this.expired = true;
            return;
        }
        effect.affect(affected, ISpellEffect.EffectType.ENTITY_SPELL_PLAGUE);
        ++this.ticksApplied;
        if (this.ticksApplied >= this.duration) {
            this.expired = true;
        }
    }

    public boolean hasExpired() {
        return this.expired;
    }

    private void readNBT(NBTTagCompound compound) {
        this.ticksApplied = compound.func_74762_e("ticks");
        this.duration = compound.func_74762_e("duration");
        this.expired = compound.func_74767_n("expired");
        String cstName = compound.func_74779_i("constellation");
        if (!cstName.isEmpty()) {
            IConstellation cst = ConstellationRegistry.getConstellationByName(cstName);
            if (cst != null) {
                this.parent = cst;
            } else {
                this.expired = true;
            }
        } else {
            this.expired = true;
        }
    }

    public void writeNBT(NBTTagCompound compound) {
        compound.func_74768_a("ticks", this.ticksApplied);
        compound.func_74768_a("duration", this.duration);
        compound.func_74757_a("expired", this.expired);
        compound.func_74778_a("constellation", this.parent.getUnlocalizedName());
    }
}

