/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.spell.plague;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.spell.plague.PlagueEffect;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;

public class SpellPlague
implements INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation CAPABILITY_NAME = new ResourceLocation("astralsorcery", "spell_plague_cap");
    @CapabilityInject(value=SpellPlague.class)
    public static Capability<SpellPlague> CAPABILITY_SPELL_PLAGUE = null;
    private List<PlagueEffect> effects = Lists.newLinkedList();

    private SpellPlague() {
    }

    public boolean onTick(EntityLivingBase affected) {
        Iterator<PlagueEffect> iterator = this.effects.iterator();
        while (iterator.hasNext()) {
            PlagueEffect effect = iterator.next();
            if (!effect.hasExpired()) {
                effect.onTick(affected);
                continue;
            }
            iterator.remove();
        }
        return this.effects.isEmpty();
    }

    public void addEffect(EntityLivingBase entity, PlagueEffect effect) {
        this.effects.add(effect);
        if (!entity.func_70644_a((Potion)RegistryPotions.potionSpellPlague)) {
            entity.func_70690_d(new PotionEffect((Potion)RegistryPotions.potionSpellPlague, 100, 0, true, false));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound cmp = new NBTTagCompound();
        NBTTagList effects = new NBTTagList();
        for (PlagueEffect effect : this.effects) {
            NBTTagCompound cmpEffect = new NBTTagCompound();
            effect.writeNBT(cmpEffect);
            effects.func_74742_a((NBTBase)cmpEffect);
        }
        cmp.func_74782_a("effects", (NBTBase)effects);
        return cmp;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList effects = nbt.func_150295_c("effects", 10);
        for (int i = 0; i < effects.func_74745_c(); ++i) {
            this.effects.add(new PlagueEffect(effects.func_150305_b(i)));
        }
    }

    public static class Factory
    implements Callable<SpellPlague> {
        @Override
        public SpellPlague call() throws Exception {
            return new SpellPlague();
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final SpellPlague defaultImpl = new SpellPlague();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY_SPELL_PLAGUE;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_SPELL_PLAGUE.cast((Object)this.defaultImpl) : null);
        }

        public NBTTagCompound serializeNBT() {
            return this.defaultImpl.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.defaultImpl.deserializeNBT(nbt);
        }
    }
}

