/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttunementRecipe
extends DiscoveryRecipe {
    private Map<AttunementAltarSlot, ItemHandle> additionalSlots = new HashMap<AttunementAltarSlot, ItemHandle>();

    protected AttunementRecipe(TileAltar.AltarLevel neededLevel, AccessibleRecipe recipe) {
        super(neededLevel, recipe);
    }

    public AttunementRecipe(AccessibleRecipe recipe) {
        super(TileAltar.AltarLevel.ATTUNEMENT, recipe);
        this.setPassiveStarlightRequirement(1400);
    }

    public AttunementRecipe setAttItem(Block b, AttunementAltarSlot ... slots) {
        return this.setAttItem(new ItemStack(b), slots);
    }

    public AttunementRecipe setAttItem(Item i, AttunementAltarSlot ... slots) {
        return this.setAttItem(new ItemStack(i), slots);
    }

    public AttunementRecipe setAttItem(ItemStack stack, AttunementAltarSlot ... slots) {
        return this.setAttItem(new ItemHandle(stack), slots);
    }

    public AttunementRecipe setAttItem(String oreDict, AttunementAltarSlot ... slots) {
        return this.setAttItem(new ItemHandle(oreDict), slots);
    }

    public AttunementRecipe setAttItem(FluidStack fluid, AttunementAltarSlot ... slots) {
        return this.setAttItem(new ItemHandle(fluid), slots);
    }

    public AttunementRecipe setAttItem(Fluid fluid, int mbAmount, AttunementAltarSlot ... slots) {
        return this.setAttItem(new FluidStack(fluid, mbAmount), slots);
    }

    public AttunementRecipe setAttItem(Fluid fluid, AttunementAltarSlot ... slots) {
        return this.setAttItem(fluid, 1000, slots);
    }

    public AttunementRecipe setAttItem(ItemHandle handle, AttunementAltarSlot ... slots) {
        for (AttunementAltarSlot slot : slots) {
            this.additionalSlots.put(slot, handle);
        }
        return this;
    }

    @Nonnull
    public List<ItemStack> getAttItems(AttunementAltarSlot slot) {
        ItemHandle handle = this.additionalSlots.get((Object)slot);
        if (handle != null) {
            return handle.getApplicableItems();
        }
        return Lists.newArrayList();
    }

    @Nullable
    public ItemHandle getAttItemHandle(AttunementAltarSlot slot) {
        return this.additionalSlots.get((Object)slot);
    }

    @Override
    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        for (AttunementAltarSlot slot : AttunementAltarSlot.values()) {
            ItemStack altarItem;
            ItemHandle expected = this.additionalSlots.get((Object)slot);
            if (!(expected != null ? !expected.matchCrafting(altarItem = invHandler.getStackInSlot(slot.slotId)) : !invHandler.getStackInSlot(slot.slotId).func_190926_b())) continue;
            return false;
        }
        return super.matches(altar, invHandler, ignoreStarlightRequirement);
    }

    @Override
    public int craftingTickTime() {
        return 300;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 pos = new Vector3(altar).add(0.5, 0.5, 0.5);
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ());
            particle.setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
            particle.motion((double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1));
            particle.scale(0.2f);
        }
    }

    @Override
    @Nonnull
    public ResearchProgression getRequiredProgression() {
        return ResearchProgression.ATTUNEMENT;
    }

    public static enum AttunementAltarSlot {
        UPPER_LEFT(9),
        UPPER_RIGHT(10),
        LOWER_LEFT(11),
        LOWER_RIGHT(12);

        private final int slotId;

        private AttunementAltarSlot(int slotId) {
            this.slotId = slotId;
        }

        public int getSlotId() {
            return this.slotId;
        }
    }
}

