/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PrismLensRecipe
extends ConstellationRecipe {
    public PrismLensRecipe() {
        super(PrismLensRecipe.shapedRecipe("crystalprism", (Block)BlocksAS.lensPrism).addPart(OreDictAlias.BLOCK_GLASS_PANE_NOCOLOR, ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.UPPER_RIGHT, ShapedRecipeSlot.LOWER_RIGHT).addPart(ItemCraftingComponent.MetaType.GLASS_LENS.asStack(), ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT).addPart(OreDictAlias.ITEM_STARMETAL_DUST, ShapedRecipeSlot.UPPER_CENTER, ShapedRecipeSlot.LOWER_CENTER).addPart(ItemHandle.getCrystalVariant(false, false), ShapedRecipeSlot.CENTER).unregisteredAccessibleShapedRecipe());
        this.setAttItem(BlockMarble.MarbleBlockType.RUNED.asStack(), AttunementRecipe.AttunementAltarSlot.LOWER_LEFT, AttunementRecipe.AttunementAltarSlot.LOWER_RIGHT);
        this.setCstItem(BlockMarble.MarbleBlockType.RUNED.asStack(), ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_LEFT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_RIGHT);
        this.setCstItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), ConstellationRecipe.ConstellationAtlarSlot.UP_UP_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_UP_RIGHT);
        this.setCstItem(OreDictAlias.BLOCK_WOOD_LOGS, ConstellationRecipe.ConstellationAtlarSlot.DOWN_RIGHT_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_LEFT_LEFT);
        this.setCstItem(OreDictAlias.ITEM_GOLD_INGOT, ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT);
    }

    @Override
    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        ItemStack lens = super.getOutput(centralGridMap, altar);
        CrystalProperties crystalProp = CrystalProperties.getCrystalProperties((ItemStack)((ItemHandle)centralGridMap.get((Object)ShapedRecipeSlot.CENTER)).getApplicableItems().get(0));
        CrystalProperties.applyCrystalProperties(lens, crystalProp);
        return lens;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 altarVec = new Vector3(altar);
            if (tick % 48L == 0L && rand.nextBoolean()) {
                EffectHandler.getInstance().textureSpritePlane(SpriteLibrary.spriteCraftBurst, Vector3.RotAxis.Y_AXIS.clone()).setPosition(altarVec.add(0.5, 0.05, 0.5)).setScale(5 + rand.nextInt(2)).setNoRotation(rand.nextInt(360));
            }
        }
    }
}

