/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.base.LightOreTransmutations;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.base.WellLiquefaction;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.InfusionRecipeRegistry;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationJEI;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class CraftingAccessManager {
    private static List<Object> lastReloadRemovedRecipes = new LinkedList<Object>();
    private static boolean completed = false;
    public static boolean ignoreJEI = true;

    public static boolean hasCompletedSetup() {
        return completed;
    }

    public static void compile() {
        AltarRecipeRegistry.compileRecipes();
        InfusionRecipeRegistry.compileRecipes();
        completed = true;
    }

    public static void clearModifications() {
        CraftingAccessManager.removeAll(InfusionRecipeRegistry.mtRecipes);
        CraftingAccessManager.removeAll(LightOreTransmutations.mtTransmutations);
        CraftingAccessManager.removeAll(WellLiquefaction.mtLiquefactions.values());
        for (Object al : TileAltar.AltarLevel.values()) {
            CraftingAccessManager.removeAll(AltarRecipeRegistry.mtRecipes.get(al));
        }
        InfusionRecipeRegistry.mtRecipes.clear();
        InfusionRecipeRegistry.recipes.clear();
        LightOreTransmutations.mtTransmutations.clear();
        WellLiquefaction.mtLiquefactions.clear();
        AltarRecipeRegistry.mtRecipes.clear();
        AltarRecipeRegistry.recipes.clear();
        for (Object e : lastReloadRemovedRecipes) {
            CraftingAccessManager.addRecipe(e);
        }
        lastReloadRemovedRecipes.clear();
        for (Object al : TileAltar.AltarLevel.values()) {
            AltarRecipeRegistry.mtRecipes.put((TileAltar.AltarLevel)((Object)al), new LinkedList());
            AltarRecipeRegistry.recipes.put((TileAltar.AltarLevel)((Object)al), new LinkedList());
        }
        InfusionRecipeRegistry.loadFromFallback();
        AltarRecipeRegistry.loadFromFallback();
        OreTypes.loadFromFallback();
        LightOreTransmutations.loadFromFallback();
        WellLiquefaction.loadFromFallback();
    }

    public static void registerMTInfusion(AbstractInfusionRecipe recipe) {
        InfusionRecipeRegistry.mtRecipes.add(recipe);
        CraftingAccessManager.addRecipe(recipe);
    }

    public static void registerMTAltarRecipe(AbstractAltarRecipe recipe) {
        TileAltar.AltarLevel al = recipe.getNeededLevel();
        AltarRecipeRegistry.mtRecipes.get((Object)al).add(recipe);
        CraftingAccessManager.addRecipe(recipe);
    }

    public static void tryRemoveInfusionByOutput(ItemStack output) {
        CraftingAccessManager.markForRemoval(InfusionRecipeRegistry.removeFindRecipeByOutput(output));
    }

    public static void tryRemoveAltarRecipeByOutputAndLevel(ItemStack output, TileAltar.AltarLevel altarLevel) {
        CraftingAccessManager.markForRemoval(AltarRecipeRegistry.removeFindRecipeByOutputAndLevel(output, altarLevel));
    }

    public static void addMTTransmutation(ItemStack in, ItemStack out, double cost) {
        IBlockState stateIn = ItemUtils.createBlockState(in);
        IBlockState stateOut = ItemUtils.createBlockState(out);
        if (stateIn != null && stateOut != null) {
            LightOreTransmutations.Transmutation tr = new LightOreTransmutations.Transmutation(stateIn, stateOut, in, out, cost);
            if ((tr = LightOreTransmutations.registerTransmutation(tr)) != null) {
                CraftingAccessManager.addRecipe(tr);
                LightOreTransmutations.mtTransmutations.add(tr);
            }
        }
    }

    public static void removeMTTransmutation(ItemStack match, boolean matchMeta) {
        CraftingAccessManager.markForRemoval(LightOreTransmutations.tryRemoveTransmutation(match, matchMeta));
    }

    public static void addMTLiquefaction(ItemStack catalystIn, Fluid producedIn, float productionMultiplier, float shatterMultiplier, Color color) {
        if (WellLiquefaction.getLiquefactionEntry(catalystIn) != null) {
            return;
        }
        WellLiquefaction.LiquefactionEntry le = new WellLiquefaction.LiquefactionEntry(catalystIn, producedIn, productionMultiplier, shatterMultiplier, color);
        WellLiquefaction.mtLiquefactions.put(catalystIn, le);
        CraftingAccessManager.addRecipe(le);
    }

    public static void removeMTLiquefaction(ItemStack match, @Nullable Fluid fluid) {
        CraftingAccessManager.markForRemoval(WellLiquefaction.tryRemoveLiquefaction(match, fluid));
    }

    private static void addRecipe(Object o) {
        if (!ignoreJEI && Mods.JEI.isPresent()) {
            ModIntegrationJEI.addRecipe(o);
        }
    }

    private static void removeAll(Collection objects) {
        if (!ignoreJEI && Mods.JEI.isPresent()) {
            for (Object o : objects) {
                ModIntegrationJEI.removeRecipe(o);
            }
        }
    }

    private static void markForRemoval(Object o) {
        if (!ignoreJEI && o != null) {
            lastReloadRemovedRecipes.add(o);
            if (Mods.JEI.isPresent()) {
                ModIntegrationJEI.removeRecipe(o);
            }
        }
    }
}

