/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.infusion;

import hellfirepvp.astralsorcery.common.crafting.IGatedRecipe;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractInfusionRecipe {
    private int uniqueRecipeId = -1;
    private float consumptionChance = 0.1f;
    private boolean consumeMultiple = false;
    @Nonnull
    protected ItemStack output = ItemStack.field_190927_a;
    @Nonnull
    protected ItemHandle input;

    public AbstractInfusionRecipe(@Nonnull ItemStack output, @Nonnull ItemHandle input) {
        this.output = output;
        this.input = input;
    }

    public AbstractInfusionRecipe setLiquidStarlightConsumptionChance(float consumptionChance) {
        this.consumptionChance = consumptionChance;
        return this;
    }

    public float getLiquidStarlightConsumptionChance() {
        return this.consumptionChance;
    }

    public void setConsumeMultiple() {
        this.consumeMultiple = true;
    }

    public boolean doesConsumeMultiple() {
        return this.consumeMultiple;
    }

    public final void updateUniqueId(int id) {
        this.uniqueRecipeId = id;
    }

    public final int getUniqueRecipeId() {
        return this.uniqueRecipeId;
    }

    public int craftingTickTime() {
        return 200;
    }

    public boolean mayDeleteInput(TileStarlightInfuser infuser) {
        return this.input.getFluidTypeAndAmount() == null;
    }

    public void handleInputDecrement(TileStarlightInfuser infuser) {
        FluidActionResult fas;
        ItemStack stack = infuser.getInputStack();
        if (!stack.func_190926_b() && (fas = ItemUtils.drainFluidFromItem(stack, this.input.getFluidTypeAndAmount(), true)).isSuccess()) {
            infuser.setStack(fas.getResult());
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ItemStack getOutputForRender() {
        return ItemUtils.copyStackWithSize(this.output, this.output.func_190916_E());
    }

    @Nonnull
    public ItemStack getOutput(@Nullable TileStarlightInfuser infuser) {
        return ItemUtils.copyStackWithSize(this.output, this.output.func_190916_E());
    }

    @Nonnull
    public ItemStack getOutputForMatching() {
        return ItemUtils.copyStackWithSize(this.output, this.output.func_190916_E());
    }

    @Nonnull
    public ItemHandle getInput() {
        return this.input;
    }

    public void onCraftServerFinish(TileStarlightInfuser infuser, Random rand) {
    }

    public void onCraftServerTick(TileStarlightInfuser infuser, int tick, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileStarlightInfuser infuser, long tick, Random rand) {
    }

    public boolean matches(TileStarlightInfuser infuser) {
        if (this instanceof IGatedRecipe && infuser.func_145831_w().field_72995_K && !((IGatedRecipe)((Object)this)).hasProgressionClient()) {
            return false;
        }
        return infuser.hasMultiblock() && !infuser.getInputStack().func_190926_b() && this.input.matchCrafting(infuser.getInputStack());
    }
}

