/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.Sync;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncConfig;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static Configuration latestConfig;
    public static List<PktSyncConfig.SyncTuple> savedSyncTuples;
    public static boolean spawnRockCrystalOres;
    public static boolean respectIdealDistances;
    public static int crystalDensity;
    public static int aquamarineAmount;
    public static int marbleAmount;
    public static int marbleVeinSize;
    public static int constellationPaperRarity;
    public static int constellationPaperQuality;
    public static boolean clientPreloadTextures;
    public static boolean giveJournalFirst;
    public static boolean doesMobSpawnDenyDenyEverything;
    @Sync
    public static boolean craftingLiqCrystalGrowth;
    @Sync
    public static boolean craftingLiqCrystalToolGrowth;
    @Sync
    public static boolean craftingLiqCelestialCrystalForm;
    @Sync
    public static boolean canCrystalGrowthYieldDuplicates;
    public static boolean enableRetroGen;
    public static int maxEffectRenderDistance;
    public static int maxEffectRenderDistanceSq;
    public static int particleAmount;
    public static int ambientFlareChance;
    public static boolean flareKillsBats;
    public static boolean shouldChargedToolsRevert;
    public static int revertStart;
    public static int revertChance;
    @Sync
    public static double swordSharpMultiplier;
    @Sync
    public static float illuminationWandUseCost;
    @Sync
    public static float grappleWandUseCost;
    @Sync
    public static float architectWandUseCost;
    @Sync
    public static float exchangeWandUseCost;
    public static List<Integer> constellationSkyDimWhitelist;
    public static List<Integer> weakSkyRendersWhitelist;
    public static List<String> modidOreGenBlacklist;
    public static List<Integer> worldGenDimWhitelist;
    public static boolean performNetworkIntegrityCheck;
    private static List<ConfigEntry> dynamicConfigEntries;

    private Config() {
    }

    public static void load(File file) {
        latestConfig = new Configuration(file);
        latestConfig.load();
        Config.loadData();
        latestConfig.save();
    }

    public static void addDynamicEntry(ConfigEntry entry) {
        if (latestConfig != null) {
            throw new IllegalStateException("Too late to add dynamic configuration entries");
        }
        dynamicConfigEntries.add(entry);
    }

    public static void rebuildClientConfig() {
        try {
            for (PktSyncConfig.SyncTuple tuple : savedSyncTuples) {
                Field field = Config.class.getField((String)tuple.key);
                field.set(null, tuple.value);
            }
            savedSyncTuples.clear();
        }
        catch (Throwable exc) {
            AstralSorcery.log.error("Failed to reapply saved client config!");
            throw new RuntimeException(exc);
        }
    }

    private static void loadData() {
        giveJournalFirst = latestConfig.getBoolean("giveJournalAtFirstJoin", "general", true, "If set to 'true', the player will receive an AstralSorcery Journal if he joins the server for the first time.");
        doesMobSpawnDenyDenyEverything = latestConfig.getBoolean("doesMobSpawnDenyAllTypes", "general", false, "If set to 'true' anything that prevents mobspawning by this mod, will also prevent EVERY natural mobspawning of any mobtype. When set to 'false' it'll only stop monsters from spawning.");
        swordSharpMultiplier = latestConfig.getFloat("swordSharpenedMultiplier", "general", 0.1f, 0.0f, 10000.0f, "Defines how much the 'sharpened' modifier increases the damage of the sword if applied. Config value is in percent.");
        String[] dimWhitelist = latestConfig.getStringList("skySupportedDimensions", "general", new String[]{"0"}, "Whitelist of dimension ID's that will have special sky rendering");
        String[] weakSkyRenders = latestConfig.getStringList("weakSkyRenders", "general", new String[0], "IF a dimensionId is listed in 'skySupportedDimensions' you can add it here to keep its sky render, but AS will try to render only constellations on top of its existing sky render.");
        Object[] oreModidBlacklist = latestConfig.getStringList("oreGenBlacklist", "general", new String[]{"techreborn"}, "List any number of modid's here and the aevitas perk & mineralis ritual will not spawn ores that originate from any of the mods listed here.");
        modidOreGenBlacklist = Lists.newArrayList((Object[])oreModidBlacklist);
        ambientFlareChance = latestConfig.getInt("EntityFlare.ambientspawn", "entities", 20, 0, 200000, "Defines how common ***ambient*** flares are. the lower the more common. 0 = ambient ones don't appear/disabled.");
        flareKillsBats = latestConfig.getBoolean("EntityFlare.killbats", "entities", true, "If this is set to true, occasionally, a spawned flare will (attempt to) kill bats close to it.");
        illuminationWandUseCost = latestConfig.getFloat("wandCost_illumination", "tools", 0.5f, 0.0f, 1.0f, "Sets the quick-charge cost for one usage of the illumination wand");
        architectWandUseCost = latestConfig.getFloat("wandCost_architect", "tools", 0.03f, 0.0f, 1.0f, "Sets the quick-charge cost for one usage of the architect wand");
        exchangeWandUseCost = latestConfig.getFloat("wandCost_exchange", "tools", 0.002f, 0.0f, 1.0f, "Sets the quick-charge cost for one usage of the exchange wand");
        grappleWandUseCost = latestConfig.getFloat("wandCost_grapple", "tools", grappleWandUseCost, 0.0f, 1.0f, "Sets the quick-charge cost for one usage of the grapple wand");
        shouldChargedToolsRevert = latestConfig.getBoolean("chargedCrystalToolsRevert", "tools", shouldChargedToolsRevert, "If this is set to true, charged crystals tools can revert back to their inert state.");
        revertStart = latestConfig.getInt("chargedCrystalToolsRevertStart", "tools", revertStart, 0, 0x7FFFFFFE, "Defines the minimum uses a user at least gets before it's trying to revert to an inert crystal tool.");
        revertChance = latestConfig.getInt("chargedCrystalToolsRevertChance", "tools", revertChance, 1, Integer.MAX_VALUE, "After 'chargedCrystalToolsRevertStart' uses, it will random.nextInt(chance) == 0 try and see if the tool gets reverted to its inert crystal tool.");
        craftingLiqCrystalGrowth = latestConfig.getBoolean("liquidStarlightCrystalGrowth", "crafting", true, "Set this to false to disable Rock/Celestial Crystal growing in liquid starlight.");
        craftingLiqCelestialCrystalForm = latestConfig.getBoolean("liquidStarlightCelestialCrystalCluster", "crafting", true, "Set this to false to disable crystal + stardust -> Celestial Crystal cluster forming");
        craftingLiqCrystalToolGrowth = latestConfig.getBoolean("liquidStarlightCrystalToolGrowth", "crafting", craftingLiqCrystalToolGrowth, "Set this to false to disable Crystal Tool growth in liquid starlight");
        canCrystalGrowthYieldDuplicates = latestConfig.getBoolean("canCrystalGrowthYieldDuplicates", "crafting", canCrystalGrowthYieldDuplicates, "Set this to false to disable the chance to get a 2nd crystal when growing a max-sized one in liquid starlight.");
        latestConfig.addCustomCategoryComment("lightnetwork", "Maintenance options for the Starlight network. Use the integrity check when you did a bigger rollback or MC-Edited stuff out of the world. Note that it will only affect worlds that get loaded. So if you edited out something on, for example, dimension -76, be sure to go into that dimension with the maintenance options enabled to properly perform maintenance there.");
        performNetworkIntegrityCheck = latestConfig.getBoolean("performNetworkIntegrityCheck", "lightnetwork", false, "NOTE: ONLY run this once and set it to false again afterwards, nothing will be gained by setting this to true permanently, just longer loading times. When set to true and the server started, this will perform an integrity check over all nodes of the starlight network whenever a world gets loaded, removing invalid ones in the process. This might, depending on network sizes, take a while. It'll leave a message in the console when it's done. After this check has been run, you might need to tear down and rebuild your starlight network in case something doesn't work anymore.");
        maxEffectRenderDistance = latestConfig.getInt("maxEffectRenderDistance", "rendering", 64, 1, 512, "Defines how close to the position of a particle/floating texture you have to be in order for it to render.");
        maxEffectRenderDistanceSq = maxEffectRenderDistance * maxEffectRenderDistance;
        clientPreloadTextures = latestConfig.getBoolean("preloadTextures", "rendering", true, "If set to 'true' the mod will preload most of the bigger textures during postInit. This provides a more fluent gameplay experience (as it doesn't need to load the textures when they're first needed), but increases loadtime.");
        particleAmount = latestConfig.getInt("particleAmount", "rendering", 2, 0, 2, "Sets the amount of particles/effects: 0 = minimal (only necessary particles will appear), 1 = lowered (most unnecessary particles will be filtered), 2 = all particles are visible");
        spawnRockCrystalOres = latestConfig.getBoolean("rockCrystalsEnabled", "worldgen", true, "Set this to false to disable rock crystal oregen entirely.");
        crystalDensity = latestConfig.getInt("crystalDensity", "worldgen", 15, 0, 40, "Defines how frequently rock-crystals will spawn underground. The lower the number, the more frequent crystals will spawn. (onWorldGen: random.nextInt(crystalDensity) == 0 -> gen 1 ore in that chunk)");
        marbleAmount = latestConfig.getInt("generateMarbleAmount", "worldgen", 4, 0, 32, "Defines how many marble veins are generated per chunk. 0 = disabled");
        marbleVeinSize = latestConfig.getInt("generateMarbleVeinSize", "worldgen", 20, 1, 32, "Defines how big generated marble veins are.");
        aquamarineAmount = latestConfig.getInt("generateAquamarineAmount", "worldgen", 64, 0, 2048, "Defines how many aquamarine ores it'll attempt to generate in per chunk. 0 = disabled");
        constellationPaperRarity = latestConfig.getInt("constellationPaperRarity", "worldgen", 10, 1, 128, "Defines the rarity of the constellation paper item in loot chests.");
        constellationPaperQuality = latestConfig.getInt("constellationPaperQuality", "worldgen", 2, 1, 128, "Defines the quality of the constellation paper item in loot chests.");
        respectIdealDistances = latestConfig.getBoolean("respectIdealStructureDistances", "worldgen", respectIdealDistances, "If this is set to true, the world generator will try and spawn structures more evenly distributed by their 'ideal' distance set in their config entries. WARNING: might add additional worldgen time.");
        String[] dimGenWhitelist = latestConfig.getStringList("worldGenWhitelist", "worldgen", new String[]{"0"}, "the Astral Sorcery-specific worldgen will only run in Dimension ID's listed here.");
        enableRetroGen = latestConfig.getBoolean("enableRetroGen", "retrogen", false, "WARNING: Setting this to true, will check on every chunk load if the chunk has been generated depending on the current AstralSorcery version. If the chunk was then generated with an older version, the mod will try and do the worldgen that's needed from the last recorded version to the current version. DO NOT ENABLE THIS FEATURE UNLESS SPECIFICALLY REQUIRED. It might/will slow down chunk loading.");
        Config.fillWhitelistIDs(dimWhitelist);
        Config.fillWeakSkyRenders(weakSkyRenders);
        Config.fillDimGenWhitelist(dimGenWhitelist);
        for (ConfigEntry ce : dynamicConfigEntries) {
            ce.loadFromConfig(latestConfig);
        }
    }

    private static void fillDimGenWhitelist(String[] dimGenWhitelist) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String s : dimGenWhitelist) {
            if (s.isEmpty()) continue;
            try {
                out.add(Integer.parseInt(s));
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.warn("[AstralSorcery] Error while reading config entry 'worldGenWhitelist': " + s + " is not a number!");
            }
        }
        worldGenDimWhitelist = new ArrayList<Integer>(out.size());
        worldGenDimWhitelist.addAll(out);
        Collections.sort(worldGenDimWhitelist);
    }

    private static void fillWeakSkyRenders(String[] weakSkyRenders) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String s : weakSkyRenders) {
            if (s.isEmpty()) continue;
            try {
                out.add(Integer.parseInt(s));
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.warn("[AstralSorcery] Error while reading config entry 'weakSkyRenders': " + s + " is not a number!");
            }
        }
        weakSkyRendersWhitelist = new ArrayList<Integer>(out.size());
        weakSkyRendersWhitelist.addAll(out);
        Collections.sort(weakSkyRendersWhitelist);
    }

    private static void fillWhitelistIDs(String[] dimWhitelist) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String s : dimWhitelist) {
            if (s.isEmpty()) continue;
            try {
                out.add(Integer.parseInt(s));
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.warn("[AstralSorcery] Error while reading config entry 'skySupportedDimensions': " + s + " is not a number!");
            }
        }
        constellationSkyDimWhitelist = Lists.newArrayList(out);
        Collections.sort(constellationSkyDimWhitelist);
    }

    static {
        savedSyncTuples = new LinkedList<PktSyncConfig.SyncTuple>();
        spawnRockCrystalOres = true;
        respectIdealDistances = true;
        crystalDensity = 15;
        aquamarineAmount = 64;
        marbleAmount = 4;
        marbleVeinSize = 20;
        constellationPaperRarity = 10;
        constellationPaperQuality = 2;
        clientPreloadTextures = true;
        giveJournalFirst = true;
        doesMobSpawnDenyDenyEverything = false;
        craftingLiqCrystalGrowth = true;
        craftingLiqCrystalToolGrowth = true;
        craftingLiqCelestialCrystalForm = true;
        canCrystalGrowthYieldDuplicates = true;
        enableRetroGen = false;
        maxEffectRenderDistance = 64;
        particleAmount = 2;
        ambientFlareChance = 20;
        flareKillsBats = true;
        shouldChargedToolsRevert = true;
        revertStart = 40;
        revertChance = 80;
        swordSharpMultiplier = 0.1;
        illuminationWandUseCost = 0.5f;
        grappleWandUseCost = 0.7f;
        architectWandUseCost = 0.07f;
        exchangeWandUseCost = 0.08f;
        constellationSkyDimWhitelist = Lists.newArrayList();
        weakSkyRendersWhitelist = Lists.newArrayList();
        modidOreGenBlacklist = Lists.newArrayList();
        worldGenDimWhitelist = Lists.newArrayList();
        performNetworkIntegrityCheck = false;
        dynamicConfigEntries = new LinkedList<ConfigEntry>();
    }
}

