/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.entry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class WorldGenEntry
extends ConfigEntry {
    private int generationChance;
    private boolean doGenerate = false;
    private boolean doIgnoreBiomeSpecifications = false;
    private BiomeDictionary.Type[] defaultBiomeTypes;
    private List<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
    private int minY;
    private int maxY;

    public WorldGenEntry(String key, int defaultChance, BiomeDictionary.Type ... applicableTypes) {
        super(ConfigEntry.Section.WORLDGEN, key);
        this.generationChance = defaultChance;
        this.defaultBiomeTypes = applicableTypes;
        this.minY = 0;
        this.maxY = 255;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        this.doGenerate = cfg.getBoolean("Generate", this.getConfigurationSection(), true, "Generate " + this.getKey());
        this.doIgnoreBiomeSpecifications = cfg.getBoolean("IgnoreBiomes", this.getConfigurationSection(), false, "Ignore Biome specifications when trying to generate " + this.getKey());
        this.generationChance = cfg.getInt("Chance", this.getConfigurationSection(), this.generationChance, 1, Integer.MAX_VALUE, "Chance to generate the structure in a chunk. The higher, the lower the chance.");
        this.minY = cfg.getInt("MinY", this.getConfigurationSection(), 0, 0, 255, "Set the minimum Y level to spawn this structure on");
        this.maxY = cfg.getInt("MaxY", this.getConfigurationSection(), 255, 0, 255, "Set the maximum Y level to spawn this structure on");
        String[] strTypes = cfg.getStringList("BiomeTypes", this.getConfigurationSection(), this.getDefaultBiomeTypes(), "Set the BiomeTypes (according to the BiomeDicitionary) this structure will spawn in.");
        LinkedList<BiomeDictionary.Type> resolvedTypes = new LinkedList<BiomeDictionary.Type>();
        for (String s : strTypes) {
            try {
                resolvedTypes.add(BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
            catch (Exception e) {
                AstralSorcery.log.error("Could not find BiomeType by name '" + s + "' - Ignoring BiomeType specification for structure " + this.getKey());
            }
        }
        this.biomeTypes = Lists.newArrayList(resolvedTypes);
    }

    @Override
    public String getConfigurationSection() {
        return super.getConfigurationSection() + "." + this.getKey();
    }

    private String[] getDefaultBiomeTypes() {
        String[] def = new String[this.defaultBiomeTypes.length];
        for (int i = 0; i < this.defaultBiomeTypes.length; ++i) {
            BiomeDictionary.Type t = this.defaultBiomeTypes[i];
            def[i] = t.getName();
        }
        return def;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public List<BiomeDictionary.Type> getTypes() {
        return this.biomeTypes;
    }

    public boolean shouldGenerate() {
        return this.doGenerate;
    }

    public boolean shouldIgnoreBiomeSpecifications() {
        return this.doIgnoreBiomeSpecifications;
    }

    public boolean tryGenerate(Random random, double chanceMultiplier) {
        return random.nextInt(Math.max((int)Math.round((double)this.generationChance * chanceMultiplier), 1)) == 0;
    }
}

