/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world.data;

import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class RockCrystalBuffer
extends CachedWorldData {
    private Map<ChunkPos, List<BlockPos>> crystalPositions = new HashMap<ChunkPos, List<BlockPos>>();
    private static final Object lock = new Object();

    public RockCrystalBuffer() {
        super(WorldCacheManager.SaveKey.ROCK_CRYSTAL);
    }

    @Override
    public void updateTick(World world) {
    }

    public List<BlockPos> collectPositions(ChunkPos center, int rad) {
        LinkedList<BlockPos> out = new LinkedList<BlockPos>();
        for (int xx = -rad; xx <= rad; ++xx) {
            for (int zz = -rad; zz <= rad; ++zz) {
                ChunkPos other = new ChunkPos(center.field_77276_a + xx, center.field_77275_b + zz);
                List<BlockPos> saved = this.crystalPositions.get(other);
                if (saved == null) continue;
                out.addAll(saved);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOre(BlockPos pos) {
        ChunkPos ch = new ChunkPos(pos);
        Object object = lock;
        synchronized (object) {
            if (!this.crystalPositions.containsKey(ch)) {
                this.crystalPositions.put(ch, new LinkedList());
            }
            this.crystalPositions.get(ch).add(pos);
        }
        this.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOre(BlockPos pos) {
        boolean removed;
        ChunkPos ch = new ChunkPos(pos);
        if (!this.crystalPositions.containsKey(ch)) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            removed = this.crystalPositions.get(ch).remove(pos);
            if (this.crystalPositions.get(ch).size() == 0) {
                this.crystalPositions.remove(ch);
                removed = true;
            }
        }
        if (removed) {
            this.markDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        Object object = lock;
        synchronized (object) {
            this.crystalPositions.clear();
        }
        HashMap<ChunkPos, List<BlockPos>> work = new HashMap<ChunkPos, List<BlockPos>>();
        if (nbt.func_74764_b("crystalList")) {
            NBTTagList list = nbt.func_150295_c("crystalList", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound chList = list.func_150305_b(i);
                int chX = chList.func_74762_e("chX");
                int chZ = chList.func_74762_e("chZ");
                ChunkPos pos = new ChunkPos(chX, chZ);
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                NBTTagList entries = chList.func_150295_c("crystals", 10);
                for (int j = 0; j < entries.func_74745_c(); ++j) {
                    NBTTagCompound tag = entries.func_150305_b(j);
                    positions.add(NBTUtils.readBlockPosFromNBT(tag));
                }
                work.put(pos, positions);
            }
        }
        Object object2 = lock;
        synchronized (object2) {
            this.crystalPositions = work;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList listCrystals = new NBTTagList();
        Object object = lock;
        synchronized (object) {
            for (ChunkPos pos : this.crystalPositions.keySet()) {
                NBTTagCompound comp = new NBTTagCompound();
                comp.func_74768_a("chX", pos.field_77276_a);
                comp.func_74768_a("chZ", pos.field_77275_b);
                NBTTagList chList = new NBTTagList();
                for (BlockPos exactPos : this.crystalPositions.get(pos)) {
                    NBTTagCompound tag = new NBTTagCompound();
                    NBTUtils.writeBlockPosToNBT(exactPos, tag);
                    chList.func_74742_a((NBTBase)tag);
                }
                comp.func_74782_a("crystals", (NBTBase)chList);
                listCrystals.func_74742_a((NBTBase)comp);
            }
        }
        nbt.func_74782_a("crystalList", (NBTBase)listCrystals);
    }
}

