/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseTweaker {
    @Nonnull
    public static ItemStack convertToItemStack(IItemStack stack) {
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        Object objStack = stack.getInternal();
        if (!(objStack instanceof ItemStack)) {
            CraftTweakerAPI.logError((String)("Invalid ItemStack: " + objStack));
            return ItemStack.field_190927_a;
        }
        return (ItemStack)objStack;
    }

    @Nullable
    public static FluidStack convertToFluidStack(ILiquidStack stack, boolean capAndLimitToBuckets) {
        if (stack == null) {
            return null;
        }
        Object objStack = stack.getInternal();
        if (!(objStack instanceof FluidStack)) {
            CraftTweakerAPI.logError((String)("Invalid FluidStack: " + objStack));
            return null;
        }
        FluidStack flStack = (FluidStack)objStack;
        if (capAndLimitToBuckets) {
            flStack.amount = 1000;
        }
        return flStack;
    }

    @Nullable
    public static ItemHandle convertToHandle(IIngredient obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IItemStack) {
            ItemStack ret = BaseTweaker.convertToItemStack((IItemStack)obj);
            if (ret.func_190926_b()) {
                return null;
            }
            return new ItemHandle(ret);
        }
        if (obj instanceof ILiquidStack) {
            FluidStack ret = BaseTweaker.convertToFluidStack((ILiquidStack)obj, true);
            if (ret == null) {
                return null;
            }
            return new ItemHandle(ret);
        }
        if (obj instanceof IOreDictEntry) {
            return new ItemHandle(((IOreDictEntry)obj).getName());
        }
        return null;
    }
}

