/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class InfusionRecipeAdd
implements SerializeableRecipe {
    private ItemStack in;
    private ItemStack out;
    private boolean consumeAll;
    private float consumeChance;
    private int craftingTickTime;

    InfusionRecipeAdd() {
    }

    public InfusionRecipeAdd(ItemStack in, ItemStack out, boolean consumeMultiple, float consumeChance, int craftingTickTime) {
        this.in = in;
        this.out = out;
        this.consumeAll = consumeMultiple;
        this.consumeChance = consumeChance;
        this.craftingTickTime = craftingTickTime;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.INFUSION_ADD;
    }

    @Override
    public void read(ByteBuf buf) {
        this.in = ByteBufUtils.readItemStack(buf);
        this.out = ByteBufUtils.readItemStack(buf);
        this.consumeAll = buf.readBoolean();
        this.consumeChance = buf.readFloat();
        this.craftingTickTime = buf.readInt();
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeItemStack(buf, this.in);
        ByteBufUtils.writeItemStack(buf, this.out);
        buf.writeBoolean(this.consumeAll);
        buf.writeFloat(this.consumeChance);
        buf.writeInt(this.craftingTickTime);
    }

    @Override
    public void applyRecipe() {
        CraftingAccessManager.registerMTInfusion(this.compile());
    }

    public AbstractInfusionRecipe compile() {
        return new AbstractInfusionRecipe(this.out, new ItemHandle(this.in)){

            @Override
            public int craftingTickTime() {
                return InfusionRecipeAdd.this.craftingTickTime;
            }

            @Override
            public boolean doesConsumeMultiple() {
                return InfusionRecipeAdd.this.consumeAll;
            }
        }.setLiquidStarlightConsumptionChance(this.consumeChance);
    }
}

