/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.common.entities.EntityItemStardust;
import hellfirepvp.astralsorcery.common.item.base.IGrindable;
import hellfirepvp.astralsorcery.common.item.base.IItemVariants;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemCraftingComponent
extends Item
implements IGrindable,
IItemVariants {
    public ItemCraftingComponent() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (MetaType type : MetaType.values()) {
                items.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
            }
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        MetaType type = MetaType.fromMeta(stack.func_77952_i());
        switch (type) {
            case STARDUST: {
                return true;
            }
        }
        return super.hasCustomEntity(stack);
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        MetaType type = MetaType.fromMeta(itemstack.func_77952_i());
        switch (type) {
            case STARDUST: {
                EntityItemStardust stardust = new EntityItemStardust(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
                stardust.func_174869_p();
                stardust.field_70159_w = location.field_70159_w;
                stardust.field_70181_x = location.field_70181_x;
                stardust.field_70179_y = location.field_70179_y;
                return stardust;
            }
        }
        return null;
    }

    public String func_77667_c(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (i instanceof ItemCraftingComponent) {
            MetaType type = MetaType.fromMeta(stack.func_77952_i());
            return super.func_77667_c(stack) + "." + type.getUnlocalizedName();
        }
        return super.func_77667_c(stack);
    }

    @Override
    public boolean canGrind(TileGrindstone grindstone, ItemStack stack) {
        MetaType type = MetaType.fromMeta(stack.func_77952_i());
        return type.isGrindable();
    }

    @Override
    @Nonnull
    public IGrindable.GrindResult grind(TileGrindstone grindstone, ItemStack stack, Random rand) {
        MetaType type = MetaType.fromMeta(stack.func_77952_i());
        switch (type) {
            case STARMETAL_INGOT: {
                if (rand.nextInt(20) != 0) break;
                return IGrindable.GrindResult.itemChange(new ItemStack((Item)this, 1, MetaType.STARDUST.getMeta()));
            }
        }
        return IGrindable.GrindResult.failNoOp();
    }

    @Override
    public String[] getVariants() {
        String[] sub = new String[MetaType.values().length];
        MetaType[] values = MetaType.values();
        for (int i = 0; i < values.length; ++i) {
            MetaType mt = values[i];
            sub[i] = mt.getUnlocalizedName();
        }
        return sub;
    }

    @Override
    public int[] getVariantMetadatas() {
        int[] sub = new int[MetaType.values().length];
        MetaType[] values = MetaType.values();
        for (int i = 0; i < values.length; ++i) {
            MetaType mt = values[i];
            sub[i] = mt.getMeta();
        }
        return sub;
    }

    public static enum MetaType {
        AQUAMARINE,
        STARMETAL_INGOT,
        STARDUST,
        GLASS_LENS,
        RESO_GEM,
        PARCHMENT;


        public ItemStack asStack() {
            return new ItemStack((Item)ItemsAS.craftingComponent, 1, this.getMeta());
        }

        public String getUnlocalizedName() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.ordinal();
        }

        public static MetaType fromMeta(int meta) {
            int ord = MathHelper.func_76125_a((int)meta, (int)0, (int)(MetaType.values().length - 1));
            return MetaType.values()[ord];
        }

        public boolean isGrindable() {
            return this == STARMETAL_INGOT;
        }
    }
}

