/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.base;

import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public interface IGrindable {
    public boolean canGrind(TileGrindstone var1, ItemStack var2);

    @Nonnull
    public GrindResult grind(TileGrindstone var1, ItemStack var2, Random var3);

    @SideOnly(value=Side.CLIENT)
    default public void applyClientGrindstoneTransforms() {
        IGrindable.applyDefaultGrindstoneTransforms();
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyDefaultGrindstoneTransforms() {
        GL11.glTranslated((double)0.55, (double)0.75, (double)0.6);
        GL11.glRotated((double)125.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
    }

    public static enum ResultType {
        SUCCESS,
        ITEMCHANGE,
        FAIL_SILENT,
        FAIL_BREAK_ITEM;

    }

    public static class GrindResult {
        private final ResultType type;
        private final ItemStack stack;

        private GrindResult(ResultType type, ItemStack stack) {
            this.type = type;
            this.stack = stack;
        }

        public ResultType getType() {
            return this.type;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }

        public static GrindResult success() {
            return new GrindResult(ResultType.SUCCESS, ItemStack.field_190927_a);
        }

        public static GrindResult itemChange(@Nonnull ItemStack newStack) {
            return new GrindResult(ResultType.ITEMCHANGE, newStack);
        }

        public static GrindResult failNoOp() {
            return new GrindResult(ResultType.FAIL_SILENT, ItemStack.field_190927_a);
        }

        public static GrindResult failBreakItem() {
            return new GrindResult(ResultType.FAIL_BREAK_ITEM, ItemStack.field_190927_a);
        }
    }
}

