/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal.base;

import hellfirepvp.astralsorcery.common.entities.EntityCrystal;
import hellfirepvp.astralsorcery.common.item.base.IGrindable;
import hellfirepvp.astralsorcery.common.item.base.ItemHighlighted;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemTunedCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemRockCrystalBase
extends Item
implements IGrindable,
ItemHighlighted {
    public ItemRockCrystalBase() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    @Override
    public boolean canGrind(TileGrindstone grindstone, ItemStack stack) {
        return true;
    }

    @Override
    @Nonnull
    public IGrindable.GrindResult grind(TileGrindstone grindstone, ItemStack stack, Random rand) {
        CrystalProperties prop = CrystalProperties.getCrystalProperties(stack);
        CrystalProperties result = prop.grindCopy(rand);
        if (result == null) {
            return IGrindable.GrindResult.failBreakItem();
        }
        CrystalProperties.applyCrystalProperties(stack, result);
        if (result.getSize() <= 0) {
            return IGrindable.GrindResult.failBreakItem();
        }
        return IGrindable.GrindResult.success();
    }

    @Override
    public Color getHightlightColor(ItemStack stack) {
        return Color.WHITE;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityCrystal crystal = new EntityCrystal(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        crystal.func_174869_p();
        crystal.func_174873_u();
        crystal.field_70159_w = location.field_70159_w;
        crystal.field_70181_x = location.field_70181_x;
        crystal.field_70179_y = location.field_70179_y;
        return crystal;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.addCrystalPropertyToolTip(stack, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    protected Optional<Boolean> addCrystalPropertyToolTip(ItemStack stack, List<String> tooltip) {
        boolean isCelestial = this instanceof ItemCelestialCrystal || this instanceof ItemTunedCelestialCrystal;
        return CrystalProperties.addPropertyTooltip(CrystalProperties.getCrystalProperties(stack), tooltip, isCelestial ? 900 : 400);
    }

    public abstract ItemTunedCrystalBase getTunedItemVariant();

    public static ItemStack createMaxBaseCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.rockCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.getMaxRockProperties());
        return crystal;
    }

    public static ItemStack createMaxCelestialCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.celestialCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.getMaxCelestialProperties());
        return crystal;
    }

    public static ItemStack createRandomBaseCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.rockCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.createRandomRock());
        return crystal;
    }

    public static ItemStack createRandomCelestialCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.celestialCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.createRandomCelestial());
        return crystal;
    }
}

