/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightning;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktLightningEffect
implements IMessage,
IMessageHandler<PktLightningEffect, IMessage> {
    private Vector3 from;
    private Vector3 to;
    private Color colorOverlay = null;

    public PktLightningEffect() {
    }

    public PktLightningEffect(Vector3 from, Vector3 to) {
        this.from = from;
        this.to = to;
    }

    public PktLightningEffect setColorOverlay(Color colorOverlay) {
        this.colorOverlay = colorOverlay;
        return this;
    }

    public void fromBytes(ByteBuf buf) {
        this.from = Vector3.fromBytes(buf);
        this.to = Vector3.fromBytes(buf);
        if (buf.readBoolean()) {
            float[] colorComponents = new float[4];
            for (int i = 0; i < colorComponents.length; ++i) {
                colorComponents[i] = buf.readFloat();
            }
            this.colorOverlay = new Color(colorComponents[0], colorComponents[1], colorComponents[2], colorComponents[3]);
        }
    }

    public void toBytes(ByteBuf buf) {
        this.from.toBytes(buf);
        this.to.toBytes(buf);
        buf.writeBoolean(this.colorOverlay != null);
        if (this.colorOverlay != null) {
            for (float color : this.colorOverlay.getComponents(new float[4])) {
                buf.writeFloat(color);
            }
        }
    }

    public IMessage onMessage(PktLightningEffect message, MessageContext ctx) {
        this.playLightningEffect(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void playLightningEffect(PktLightningEffect p) {
        EffectLightning lightning = EffectHandler.getInstance().lightning(p.from, p.to);
        if (p.colorOverlay != null) {
            lightning.setOverlayColor(p.colorOverlay);
        }
    }
}

