/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.Sync;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktSyncConfig
implements IMessage,
IMessageHandler<PktSyncConfig, IMessage> {
    public List<SyncTuple> fields = new ArrayList<SyncTuple>();

    public void fromBytes(ByteBuf buf) {
        int i;
        int count = buf.readByte();
        this.fields = new ArrayList<SyncTuple>(count);
        for (i = 0; i < count; ++i) {
            this.fields.add(new SyncTuple(null, null));
        }
        for (i = 0; i < count; ++i) {
            byte[] data = new byte[buf.readShort()];
            buf.readBytes(data);
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            SyncTuple tuple = null;
            String key = null;
            try {
                key = new DataInputStream(in).readUTF();
                Object value = new ObjectInputStream(in).readObject();
                tuple = new SyncTuple(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tuple == null) {
                this.fields = null;
                if (key == null) break;
                AstralSorcery.log.info("Could not read config from server with key: " + key);
                break;
            }
            this.fields.set(i, tuple);
        }
    }

    public void toBytes(ByteBuf buf) {
        ArrayList<byte[]> bufferedFieldContents = new ArrayList<byte[]>();
        for (Field f : Config.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.isAnnotationPresent(Sync.class)) continue;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                new DataOutputStream(byteStream).writeUTF(f.getName());
                new ObjectOutputStream(byteStream).writeObject(f.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            bufferedFieldContents.add(byteStream.toByteArray());
            try {
                byteStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        buf.writeByte(bufferedFieldContents.size());
        for (byte[] data : bufferedFieldContents) {
            buf.writeShort(data.length);
            buf.writeBytes(data);
        }
    }

    public IMessage onMessage(PktSyncConfig message, MessageContext ctx) {
        try {
            Config.savedSyncTuples.clear();
            for (SyncTuple tuple : message.fields) {
                Field field = Config.class.getField((String)tuple.key);
                Config.savedSyncTuples.add(new SyncTuple((String)tuple.key, field.get(null)));
                field.set(null, tuple.value);
            }
        }
        catch (Throwable exc) {
            AstralSorcery.log.error("Could not applyServer config received from server!");
            throw new RuntimeException(exc);
        }
        return null;
    }

    public static class SyncTuple
    extends Tuple<String, Object> {
        public SyncTuple(String key, Object value) {
            super(key, value);
        }
    }
}

