/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission;

import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IPrismTransmissionNode {
    public BlockPos getPos();

    default public CrystalProperties getTransmissionProperties() {
        return CrystalProperties.getMaxCelestialProperties();
    }

    default public float getAdditionalTransmissionLossMultiplier() {
        return 1.0f;
    }

    default public boolean needsTransmissionUpdate() {
        return false;
    }

    default public void onTransmissionTick(World world) {
    }

    public boolean notifyUnlink(World var1, BlockPos var2);

    public void notifyLink(World var1, BlockPos var2);

    public void notifySourceLink(World var1, BlockPos var2);

    public void notifySourceUnlink(World var1, BlockPos var2);

    public boolean notifyBlockChange(World var1, BlockPos var2);

    public List<NodeConnection<IPrismTransmissionNode>> queryNext(WorldNetworkHandler var1);

    public List<BlockPos> getSources();

    default public boolean needsUpdate() {
        return false;
    }

    default public void update(World world) {
    }

    default public void postLoad(World world) {
    }

    default public void markDirty(World world) {
        ((CachedWorldData)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.LIGHT_NETWORK)).markDirty();
    }

    public TransmissionClassRegistry.TransmissionProvider getProvider();

    public void readFromNBT(NBTTagCompound var1);

    public void writeToNBT(NBTTagCompound var1);
}

