/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.item.tool.ItemChargedCrystalShovel;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktDualParticleEvent;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileFakeTree
extends TileEntityTick {
    private TickAction ta;
    private IBlockState fakedState;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.ticksExisted > 5 && this.ticksExisted % 4 == 0) {
            if (this.ta != null) {
                this.ta.update(this);
            }
            if (this.fakedState == null || this.fakedState.func_177230_c().equals(Blocks.field_150350_a)) {
                this.cleanUp();
            }
        }
    }

    private void cleanUp() {
        if (this.fakedState != null) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.fakedState);
        } else {
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
    }

    @Override
    protected void onFirstTick() {
    }

    public void setupTile(BlockPos treeBeaconRef, IBlockState fakedState) {
        this.ta = new TreeBeaconRef(treeBeaconRef);
        this.fakedState = fakedState;
        this.markForUpdate();
    }

    public void setupTile(EntityPlayer breakingPlayer, ItemStack usedAxe, IBlockState fakedState) {
        this.ta = new PlayerHarvestRef(breakingPlayer, usedAxe);
        this.fakedState = fakedState;
        this.markForUpdate();
    }

    public IBlockState getFakedState() {
        return this.fakedState;
    }

    @Nullable
    public BlockPos getReference() {
        return this.ta instanceof TreeBeaconRef ? ((TreeBeaconRef)this.ta).ref : null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        int index = compound.func_74762_e("type");
        if (index == 0) {
            this.ta = new TreeBeaconRef(null);
            this.ta.read(compound);
        } else {
            this.ta = new ClearAction();
        }
        if (compound.func_74764_b("Block") && compound.func_74764_b("Data")) {
            int data = compound.func_74762_e("Data");
            Block b = Block.func_149684_b((String)compound.func_74779_i("Block"));
            if (b != null) {
                this.fakedState = b.func_176203_a(data);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        if (this.ta instanceof TreeBeaconRef) {
            compound.func_74768_a("type", 0);
        } else if (this.ta instanceof PlayerHarvestRef) {
            compound.func_74768_a("type", 1);
        }
        if (this.ta != null) {
            this.ta.write(compound);
        }
        if (this.fakedState != null) {
            compound.func_74778_a("Block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.fakedState.func_177230_c())).toString());
            compound.func_74768_a("Data", this.fakedState.func_177230_c().func_176201_c(this.fakedState));
        }
    }

    @Override
    public void writeNetNBT(NBTTagCompound compound) {
        super.writeNetNBT(compound);
        compound.func_74768_a("type", 0);
    }

    private static class TreeBeaconRef
    implements TickAction {
        private BlockPos ref;

        private TreeBeaconRef(BlockPos ref) {
            this.ref = ref;
        }

        @Override
        public void update(TileFakeTree tft) {
            TileTreeBeacon beacon;
            if (MiscUtils.isChunkLoaded(tft.field_145850_b, new ChunkPos(this.ref)) && ((beacon = MiscUtils.getTileAt((IBlockAccess)tft.field_145850_b, this.ref, TileTreeBeacon.class, true)) == null || beacon.func_145837_r())) {
                tft.cleanUp();
            }
        }

        @Override
        public void write(NBTTagCompound cmp) {
            if (this.ref != null) {
                NBTUtils.writeBlockPosToNBT(this.ref, cmp);
            }
        }

        @Override
        public void read(NBTTagCompound cmp) {
            this.ref = NBTUtils.readBlockPosFromNBT(cmp);
        }
    }

    private static class PlayerHarvestRef
    implements TickAction {
        private EntityPlayer player;
        private ItemStack usedTool;

        private PlayerHarvestRef(EntityPlayer player, ItemStack usedAxe) {
            this.player = player;
            if (usedAxe != null) {
                this.usedTool = usedAxe.func_77946_l();
                Map levels = EnchantmentHelper.func_82781_a((ItemStack)this.usedTool);
                if (levels.containsKey(Enchantments.field_185308_t)) {
                    levels.put(Enchantments.field_185308_t, (Integer)levels.get(Enchantments.field_185308_t) + 2);
                } else {
                    levels.put(Enchantments.field_185308_t, 2);
                }
                EnchantmentHelper.func_82782_a((Map)levels, (ItemStack)this.usedTool);
            } else {
                this.usedTool = null;
            }
        }

        @Override
        public void update(TileFakeTree tft) {
            if (tft.ticksExisted <= 10) {
                return;
            }
            if (this.player != null && this.player instanceof EntityPlayerMP && !MiscUtils.isPlayerFakeMP((EntityPlayerMP)this.player) && tft.fakedState != null) {
                NonNullList out = NonNullList.func_191196_a();
                this.harvestAndAppend(tft, (NonNullList<ItemStack>)out);
                if (rand.nextBoolean()) {
                    this.harvestAndAppend(tft, (NonNullList<ItemStack>)out);
                }
                Vector3 plPos = Vector3.atEntityCenter((Entity)this.player);
                for (ItemStack stack : out) {
                    ItemUtils.dropItemNaturally(this.player.func_130014_f_(), plPos.getX() + (double)rand.nextFloat() - (double)rand.nextFloat(), plPos.getY() + (double)rand.nextFloat(), plPos.getZ() + (double)rand.nextFloat() - (double)rand.nextFloat(), stack);
                }
                PktDualParticleEvent ev = new PktDualParticleEvent(PktDualParticleEvent.DualParticleEventType.CHARGE_HARVEST, new Vector3(tft), Vector3.atEntityCenter((Entity)this.player));
                if (this.usedTool != null && this.usedTool.func_77973_b() instanceof ItemChargedCrystalShovel) {
                    ev.setAdditionalData(Color.GRAY.brighter().getRGB());
                } else {
                    ev.setAdditionalData(Color.GREEN.getRGB());
                }
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(tft.field_145850_b, tft.func_174877_v(), 24.0));
            }
            tft.func_145831_w().func_175698_g(tft.func_174877_v());
        }

        private void harvestAndAppend(TileFakeTree tft, NonNullList<ItemStack> out) {
            BlockDropCaptureAssist.startCapturing(false);
            tft.getFakedState().func_177230_c().func_180657_a(this.player.func_130014_f_(), this.player, tft.func_174877_v(), tft.getFakedState(), null, this.usedTool);
            out.addAll(BlockDropCaptureAssist.getCapturedStacksAndStop());
        }

        @Override
        public void write(NBTTagCompound cmp) {
        }

        @Override
        public void read(NBTTagCompound cmp) {
        }
    }

    private static class ClearAction
    implements TickAction {
        private ClearAction() {
        }

        @Override
        public void update(TileFakeTree tft) {
            tft.field_145850_b.func_175698_g(tft.func_174877_v());
        }

        @Override
        public void write(NBTTagCompound cmp) {
        }

        @Override
        public void read(NBTTagCompound cmp) {
        }
    }

    private static interface TickAction {
        public void update(TileFakeTree var1);

        public void write(NBTTagCompound var1);

        public void read(NBTTagCompound var1);
    }
}

