/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.network;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.item.ItemColoredLens;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.CrystalPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.CrystalTransmissionNode;
import hellfirepvp.astralsorcery.common.tile.base.TileTransmissionBase;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCrystalLens
extends TileTransmissionBase {
    private CrystalProperties properties;
    private ItemColoredLens.ColorType lensColor;
    private int lensEffectTimeout = 0;
    private List<BlockPos> occupiedConnections = new LinkedList<BlockPos>();

    public CrystalProperties getCrystalProperties() {
        return this.properties;
    }

    public void onPlace(CrystalProperties properties) {
        this.properties = properties;
        this.markForUpdate();
    }

    public void onTransmissionTick() {
        this.lensEffectTimeout = 5;
    }

    @Nullable
    public ItemColoredLens.ColorType setLensColor(ItemColoredLens.ColorType type) {
        ItemColoredLens.ColorType old = this.lensColor;
        this.lensColor = type;
        this.markForUpdate();
        IPrismTransmissionNode node = this.getNode();
        if (node != null) {
            boolean shouldIgnore;
            boolean bl = shouldIgnore = type == ItemColoredLens.ColorType.SPECTRAL;
            if (node instanceof CrystalTransmissionNode) {
                if (shouldIgnore != ((CrystalTransmissionNode)node).ignoresBlockCollision()) {
                    ((CrystalTransmissionNode)node).updateIgnoreBlockCollisionState(this.field_145850_b, shouldIgnore);
                }
                if (this.lensColor != null) {
                    ((CrystalTransmissionNode)node).updateAdditionalLoss(1.0f - this.lensColor.getFlowReduction());
                } else {
                    ((CrystalTransmissionNode)node).updateAdditionalLoss(1.0f);
                }
            } else if (node instanceof CrystalPrismTransmissionNode) {
                if (shouldIgnore != ((CrystalPrismTransmissionNode)node).ignoresBlockCollision()) {
                    ((CrystalPrismTransmissionNode)node).updateIgnoreBlockCollisionState(this.field_145850_b, shouldIgnore);
                }
                if (this.lensColor != null) {
                    ((CrystalPrismTransmissionNode)node).updateAdditionalLoss(1.0f - this.lensColor.getFlowReduction());
                } else {
                    ((CrystalPrismTransmissionNode)node).updateAdditionalLoss(1.0f);
                }
            }
        }
        return old;
    }

    public List<BlockPos> getOccupiedConnections() {
        return this.occupiedConnections;
    }

    @Nullable
    public ItemColoredLens.ColorType getLensColor() {
        return this.lensColor;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.lensColor != null) {
            if (this.field_145850_b.field_72995_K) {
                this.playColorEffects();
            } else {
                this.doLensColorEffects(this.lensColor);
            }
        }
    }

    private void doLensColorEffects(ItemColoredLens.ColorType lensColor) {
        if (this.getTicksExisted() % 4 != 0) {
            return;
        }
        if (this.lensEffectTimeout > 0) {
            --this.lensEffectTimeout;
        } else {
            return;
        }
        this.occupiedConnections.clear();
        Vector3 thisVec = new Vector3(this).add(0.5, 0.5, 0.5);
        List<BlockPos> linked = this.getLinkedPositions();
        float str = 1.0f / (float)linked.size();
        str *= 0.7f;
        for (BlockPos linkedTo : linked) {
            Vector3 to = new Vector3(linkedTo).add(0.5, 0.5, 0.5);
            RaytraceAssist rta = new RaytraceAssist(thisVec, to).includeEndPoint();
            if (lensColor.getType() == ItemColoredLens.TargetType.BLOCK) {
                boolean clear = rta.isClear(this.field_145850_b);
                if (clear || rta.blockHit() == null) continue;
                BlockPos hit = rta.blockHit();
                IBlockState hitState = this.field_145850_b.func_180495_p(hit);
                if (!hit.equals((Object)to.toBlockPos()) || !hitState.func_177230_c().equals(BlocksAS.lens) && !hitState.func_177230_c().equals((Object)BlocksAS.lensPrism)) {
                    lensColor.onBlockOccupyingBeam(this.field_145850_b, hit, hitState, str);
                }
                this.occupiedConnections.add(hit);
                continue;
            }
            if (lensColor.getType() != ItemColoredLens.TargetType.ENTITY) continue;
            rta.setCollectEntities(0.5);
            rta.isClear(this.field_145850_b);
            List<Entity> found = rta.collectedEntities(this.field_145850_b);
            float pStr = lensColor == ItemColoredLens.ColorType.FIRE ? str / 2.0f : str;
            for (Entity entity : found) {
                lensColor.onEntityInBeam(thisVec, to, entity, pStr);
            }
        }
        this.markForUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    private void playColorEffects() {
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        if (rView.func_174818_b(this.func_174877_v()) > (double)Config.maxEffectRenderDistanceSq) {
            return;
        }
        Vector3 pos = new Vector3(this).add(0.5, 0.5, 0.5);
        EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ());
        particle.setColor(this.lensColor.wrappedColor);
        particle.motion((double)rand.nextFloat() * 0.03 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.03 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.03 * (double)(rand.nextBoolean() ? 1 : -1));
        particle.scale(0.2f);
        Vector3 source = new Vector3(this).add(0.5, 0.5, 0.5);
        Color overlay = this.lensColor.wrappedColor;
        if (this.getTicksExisted() % 40 == 0) {
            for (BlockPos dst : this.occupiedConnections) {
                Vector3 to = new Vector3(dst).add(0.5, 0.5, 0.5);
                EffectLightbeam beam = EffectHandler.getInstance().lightbeam(to, source, 0.6);
                beam.setColorOverlay((float)overlay.getRed() / 255.0f, (float)overlay.getGreen() / 255.0f, (float)overlay.getBlue() / 255.0f, 1.0f);
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.properties = CrystalProperties.readFromNBT(compound);
        int col = compound.func_74762_e("color");
        this.lensColor = col >= 0 && col < ItemColoredLens.ColorType.values().length ? ItemColoredLens.ColorType.values()[col] : null;
        this.occupiedConnections.clear();
        NBTTagList list = compound.func_150295_c("listOccupied", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            BlockPos bp = NBTUtils.readBlockPosFromNBT(tag);
            this.occupiedConnections.add(bp);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.properties.writeToNBT(compound);
        compound.func_74768_a("color", this.lensColor != null ? this.lensColor.ordinal() : -1);
        NBTTagList list = new NBTTagList();
        for (BlockPos to : this.occupiedConnections) {
            NBTTagCompound cmp = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(to, cmp);
            list.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("listOccupied", (NBTBase)list);
    }

    @Override
    public void onLinkCreate(EntityPlayer player, BlockPos other) {
        super.onLinkCreate(player, other);
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blocklens.name";
    }

    @Override
    @Nonnull
    public IPrismTransmissionNode provideTransmissionNode(BlockPos at) {
        return new CrystalTransmissionNode(at, this.getCrystalProperties());
    }
}

