/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scala.actors.threadpool.Arrays;

public interface BlockStateCheck {
    public boolean isStateValid(World var1, BlockPos var2, IBlockState var3);

    public static class AnyMeta
    implements BlockStateCheck {
        private final Collection<Integer> passableMetadataValues;
        private final net.minecraft.block.Block block;

        public AnyMeta(net.minecraft.block.Block block, int meta) {
            this(block, new int[]{meta});
        }

        public AnyMeta(net.minecraft.block.Block block, int ... values) {
            this.passableMetadataValues = new ArrayList<Integer>(values.length);
            for (int val : values) {
                this.passableMetadataValues.add(val);
            }
            this.block = block;
        }

        public AnyMeta(net.minecraft.block.Block block, Integer ... values) {
            this.passableMetadataValues = Arrays.asList((Object[])values);
            this.block = block;
        }

        public AnyMeta(net.minecraft.block.Block block, Collection<Integer> passableMetadataValues) {
            this.passableMetadataValues = passableMetadataValues;
            this.block = block;
        }

        public AnyMeta copyWithAdditionalMeta(int add) {
            AnyMeta ret = new AnyMeta(this.block, this.passableMetadataValues);
            if (!ret.passableMetadataValues.contains(add)) {
                ret.passableMetadataValues.add(add);
            }
            return ret;
        }

        @Override
        public boolean isStateValid(World world, BlockPos pos, IBlockState state) {
            return state.func_177230_c().equals(this.block) && this.passableMetadataValues.contains(state.func_177230_c().func_176201_c(state));
        }
    }

    public static class Meta
    implements BlockStateCheck {
        private final int toCheck;
        private final net.minecraft.block.Block block;

        public Meta(net.minecraft.block.Block block, int toCheck) {
            this.toCheck = toCheck;
            this.block = block;
        }

        public AnyMeta copyWithAdditionalMeta(int add) {
            AnyMeta ret = new AnyMeta(this.block, Lists.newArrayList((Object[])new Integer[]{this.toCheck}));
            if (!ret.passableMetadataValues.contains(add)) {
                ret.passableMetadataValues.add(add);
            }
            return ret;
        }

        @Override
        public boolean isStateValid(World world, BlockPos pos, IBlockState state) {
            return state.func_177230_c().equals(this.block) && state.func_177230_c().func_176201_c(state) == this.toCheck;
        }
    }

    public static class Block
    implements BlockStateCheck {
        private final List<net.minecraft.block.Block> toCheck;

        public Block(net.minecraft.block.Block ... toCheck) {
            this.toCheck = Lists.newArrayList((Object[])toCheck);
        }

        @Override
        public boolean isStateValid(World world, BlockPos pos, IBlockState state) {
            return this.toCheck.contains(world.func_180495_p(pos).func_177230_c());
        }
    }
}

