/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;

public class CropHelper {
    @Nullable
    public static GrowablePlant wrapPlant(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (state.func_177230_c() instanceof IGrowable) {
            if (b instanceof BlockGrass) {
                return null;
            }
            if (b instanceof BlockTallGrass) {
                return null;
            }
            if (b instanceof BlockDoublePlant) {
                return null;
            }
            return new GrowableWrapper(pos);
        }
        if (state.func_177230_c().equals(Blocks.field_150436_aH) && CropHelper.isReedBase(world, pos)) {
            return new GrowableReedWrapper(pos);
        }
        if (state.func_177230_c().equals(Blocks.field_150434_aF) && CropHelper.isCactusBase(world, pos)) {
            return new GrowableCactusWrapper(pos);
        }
        if (state.func_177230_c().equals(Blocks.field_150388_bm)) {
            return new GrowableNetherwartWrapper(pos);
        }
        return null;
    }

    @Nullable
    public static HarvestablePlant wrapHarvestablePlant(World world, BlockPos pos) {
        GrowablePlant growable = CropHelper.wrapPlant(world, pos);
        if (growable == null) {
            return null;
        }
        IBlockState state = world.func_180495_p(growable.getPos());
        if (state.func_177230_c().equals(Blocks.field_150436_aH) && growable instanceof GrowableReedWrapper) {
            return (GrowableReedWrapper)growable;
        }
        if (state.func_177230_c().equals(Blocks.field_150434_aF) && growable instanceof GrowableCactusWrapper) {
            return (GrowableCactusWrapper)growable;
        }
        if (state.func_177230_c().equals(Blocks.field_150388_bm) && growable instanceof GrowableNetherwartWrapper) {
            return (GrowableNetherwartWrapper)growable;
        }
        if (state.func_177230_c() instanceof IPlantable) {
            return new HarvestableWrapper(pos);
        }
        return null;
    }

    private static boolean isReedBase(World world, BlockPos pos) {
        return !world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150436_aH);
    }

    private static boolean isCactusBase(World world, BlockPos pos) {
        return !world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150434_aF);
    }

    public static class GrowableWrapper
    implements GrowablePlant {
        private final BlockPos pos;

        public GrowableWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
        }

        @Override
        public boolean isValid(World world, boolean forceChunkLoad) {
            if (!forceChunkLoad && !MiscUtils.isChunkLoaded(world, new ChunkPos(this.pos))) {
                return true;
            }
            GrowablePlant res = CropHelper.wrapPlant(world, this.pos);
            return res != null && res instanceof GrowableWrapper;
        }

        @Override
        public boolean canGrow(World world) {
            IBlockState at = world.func_180495_p(this.pos);
            return at.func_177230_c() instanceof IGrowable && (((IGrowable)at.func_177230_c()).func_176473_a(world, this.pos, at, false) || at.func_177230_c() instanceof BlockStem && !this.stemHasCrop(world));
        }

        private boolean stemHasCrop(World world) {
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                Block offset = world.func_180495_p(this.pos.func_177972_a(enumfacing)).func_177230_c();
                if (!offset.equals(Blocks.field_150440_ba) && !offset.equals(Blocks.field_150423_aK)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryGrow(World world, Random rand) {
            IBlockState at = world.func_180495_p(this.pos);
            if (at.func_177230_c() instanceof IGrowable) {
                if (((IGrowable)at.func_177230_c()).func_176473_a(world, this.pos, at, false)) {
                    if (!((IGrowable)at.func_177230_c()).func_180670_a(world, rand, this.pos, at) && world.field_73012_v.nextInt(40) != 0) {
                        return true;
                    }
                    ((IGrowable)at.func_177230_c()).func_176474_b(world, rand, this.pos, at);
                    return true;
                }
                if (at.func_177230_c() instanceof BlockStem) {
                    for (int i = 0; i < 10; ++i) {
                        at.func_177230_c().func_180650_b(world, this.pos, at, rand);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class GrowableReedWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public GrowableReedWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean canHarvest(World world) {
            return world.func_180495_p(this.pos.func_177984_a()).func_177230_c().equals(Blocks.field_150436_aH);
        }

        @Override
        public List<ItemStack> harvestDropsAndReplant(World world, Random rand, int harvestFortune) {
            LinkedList drops = Lists.newLinkedList();
            for (int i = 2; i > 0; --i) {
                BlockPos bp = this.pos.func_177981_b(i);
                IBlockState at = world.func_180495_p(bp);
                if (!at.func_177230_c().equals(Blocks.field_150436_aH)) continue;
                drops.addAll(at.func_177230_c().getDrops((IBlockAccess)world, bp, at, harvestFortune));
                world.func_175698_g(bp);
            }
            return drops;
        }

        @Override
        public boolean isValid(World world, boolean forceChunkLoad) {
            if (!forceChunkLoad && !MiscUtils.isChunkLoaded(world, new ChunkPos(this.pos))) {
                return true;
            }
            return world.func_180495_p(this.pos).func_177230_c().equals(Blocks.field_150436_aH);
        }

        @Override
        public boolean canGrow(World world) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                if (!world.func_175623_d(cache = cache.func_177984_a())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryGrow(World world, Random rand) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                if (!world.func_175623_d(cache = cache.func_177984_a())) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a(cache, Blocks.field_150436_aH.func_176223_P());
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
        }
    }

    public static class GrowableCactusWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public GrowableCactusWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean canHarvest(World world) {
            return world.func_180495_p(this.pos.func_177984_a()).func_177230_c().equals(Blocks.field_150434_aF);
        }

        @Override
        public boolean isValid(World world, boolean forceChunkLoad) {
            if (!forceChunkLoad && !MiscUtils.isChunkLoaded(world, new ChunkPos(this.pos))) {
                return true;
            }
            return world.func_180495_p(this.pos).func_177230_c().equals(Blocks.field_150434_aF);
        }

        @Override
        public List<ItemStack> harvestDropsAndReplant(World world, Random rand, int harvestFortune) {
            LinkedList drops = Lists.newLinkedList();
            for (int i = 2; i > 0; --i) {
                BlockPos bp = this.pos.func_177981_b(i);
                IBlockState at = world.func_180495_p(bp);
                if (!at.func_177230_c().equals(Blocks.field_150434_aF)) continue;
                MiscUtils.breakBlockWithoutPlayer((WorldServer)world, bp);
            }
            return drops;
        }

        @Override
        public boolean canGrow(World world) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                if (!world.func_175623_d(cache = cache.func_177984_a())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryGrow(World world, Random rand) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                if (!world.func_175623_d(cache = cache.func_177984_a())) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a(cache, Blocks.field_150434_aF.func_176223_P());
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
        }
    }

    public static class GrowableNetherwartWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public GrowableNetherwartWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean isValid(World world, boolean forceChunkLoad) {
            if (!forceChunkLoad && !MiscUtils.isChunkLoaded(world, new ChunkPos(this.pos))) {
                return true;
            }
            return world.func_180495_p(this.pos).func_177230_c().equals(Blocks.field_150388_bm);
        }

        @Override
        public boolean canGrow(World world) {
            IBlockState at = world.func_180495_p(this.pos);
            return at.func_177230_c().equals(Blocks.field_150388_bm) && (Integer)at.func_177229_b((IProperty)BlockNetherWart.field_176486_a) < 3;
        }

        @Override
        public boolean tryGrow(World world, Random rand) {
            if (rand.nextBoolean()) {
                IBlockState current = world.func_180495_p(this.pos);
                world.func_180501_a(this.pos, current.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(Math.min(3, (Integer)current.func_177229_b((IProperty)BlockNetherWart.field_176486_a) + 1))), 3);
                return true;
            }
            return false;
        }

        @Override
        public boolean canHarvest(World world) {
            IBlockState current = world.func_180495_p(this.pos);
            return current.func_177230_c().equals(Blocks.field_150388_bm) && (Integer)current.func_177229_b((IProperty)BlockNetherWart.field_176486_a) >= 3;
        }

        @Override
        public List<ItemStack> harvestDropsAndReplant(World world, Random rand, int harvestFortune) {
            IBlockState current = world.func_180495_p(this.pos);
            List drops = current.func_177230_c().getDrops((IBlockAccess)world, this.pos, current, harvestFortune);
            world.func_180501_a(this.pos, Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(1)), 3);
            return drops;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
        }
    }

    public static class HarvestableWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public HarvestableWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean canHarvest(World world) {
            IBlockState at = world.func_180495_p(this.pos);
            if (!(at.func_177230_c() instanceof IGrowable)) {
                return false;
            }
            return !((IGrowable)at.func_177230_c()).func_176473_a(world, this.pos, at, false);
        }

        @Override
        public List<ItemStack> harvestDropsAndReplant(World world, Random rand, int harvestFortune) {
            LinkedList drops = Lists.newLinkedList();
            if (this.canHarvest(world)) {
                BlockPos pos = this.getPos();
                IBlockState at = world.func_180495_p(this.getPos());
                if (at.func_177230_c() instanceof IPlantable) {
                    drops.addAll(at.func_177230_c().getDrops((IBlockAccess)world, pos, at, harvestFortune));
                    world.func_175698_g(pos);
                    world.func_175656_a(pos, ((IPlantable)at.func_177230_c()).getPlant((IBlockAccess)world, pos));
                }
            }
            return drops;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
        }

        @Override
        public boolean isValid(World world, boolean forceChunkLoad) {
            if (!forceChunkLoad && !MiscUtils.isChunkLoaded(world, new ChunkPos(this.getPos()))) {
                return true;
            }
            HarvestablePlant plant = CropHelper.wrapHarvestablePlant(world, this.getPos());
            return plant != null && plant instanceof HarvestableWrapper;
        }

        @Override
        public boolean canGrow(World world) {
            IBlockState at = world.func_180495_p(this.pos);
            return at.func_177230_c() instanceof IGrowable && ((IGrowable)at.func_177230_c()).func_176473_a(world, this.pos, at, false);
        }

        @Override
        public boolean tryGrow(World world, Random rand) {
            IBlockState at = world.func_180495_p(this.pos);
            if (at.func_177230_c() instanceof IGrowable && ((IGrowable)at.func_177230_c()).func_176473_a(world, this.pos, at, false)) {
                ((IGrowable)at.func_177230_c()).func_176474_b(world, rand, this.pos, at);
                return true;
            }
            return false;
        }
    }

    public static interface HarvestablePlant
    extends GrowablePlant {
        public boolean canHarvest(World var1);

        public List<ItemStack> harvestDropsAndReplant(World var1, Random var2, int var3);
    }

    public static interface GrowablePlant
    extends CEffectPositionListGen.CEffectGenListEntry {
        public boolean isValid(World var1, boolean var2);

        public boolean canGrow(World var1);

        public boolean tryGrow(World var1, Random var2);
    }
}

