/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.base.Predicate;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EntityUtils {
    public static void applyVortexMotion(Function<Void, Vector3> getPositionFunction, Function<Vector3, Object> addMotionFunction, Vector3 to, double vortexRange, double multiplier) {
        double diffZ;
        double diffY;
        Vector3 pos = getPositionFunction.apply(null);
        double diffX = (to.getX() - pos.getX()) / vortexRange;
        double dist = Math.sqrt(diffX * diffX + (diffY = (to.getY() - pos.getY()) / vortexRange) * diffY + (diffZ = (to.getZ() - pos.getZ()) / vortexRange) * diffZ);
        if (1.0 - dist > 0.0) {
            double dstFactorSq = (1.0 - dist) * (1.0 - dist);
            Vector3 toAdd = new Vector3();
            toAdd.setX(diffX / dist * dstFactorSq * 0.15 * multiplier);
            toAdd.setY(diffY / dist * dstFactorSq * 0.25 * multiplier);
            toAdd.setZ(diffZ / dist * dstFactorSq * 0.15 * multiplier);
            addMotionFunction.apply(toAdd);
        }
    }

    public static Predicate<? super Entity> selectEntities(final Class<? extends Entity> ... entities) {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (entity == null || entity.field_70128_L) {
                    return false;
                }
                Class<?> clazz = entity.getClass();
                for (Class test : entities) {
                    if (!test.isAssignableFrom(clazz)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<? super Entity> selectItemClassInstaceof(final Class<?> itemClass) {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (entity == null || entity.field_70128_L) {
                    return false;
                }
                if (!(entity instanceof EntityItem)) {
                    return false;
                }
                ItemStack i = ((EntityItem)entity).func_92059_d();
                if (i.func_190926_b()) {
                    return false;
                }
                return itemClass.isAssignableFrom(i.func_77973_b().getClass());
            }
        };
    }

    public static Predicate<? super Entity> selectItem(final Item item) {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (entity == null || entity.field_70128_L) {
                    return false;
                }
                if (!(entity instanceof EntityItem)) {
                    return false;
                }
                ItemStack i = ((EntityItem)entity).func_92059_d();
                if (i.func_190926_b()) {
                    return false;
                }
                return i.func_77973_b().equals(item);
            }
        };
    }

    public static Predicate<? super Entity> selectItemStack(Function<ItemStack, Boolean> acceptor) {
        return entity -> {
            if (entity == null || entity.field_70128_L) {
                return false;
            }
            if (!(entity instanceof EntityItem)) {
                return false;
            }
            ItemStack i = ((EntityItem)entity).func_92059_d();
            if (i.func_190926_b()) {
                return false;
            }
            return (Boolean)acceptor.apply(i);
        };
    }

    @Nullable
    public static <T> T selectClosest(Collection<T> elements, Function<T, Double> dstFunc) {
        if (elements.isEmpty()) {
            return null;
        }
        double dstClosest = Double.MAX_VALUE;
        T closestElement = null;
        for (T element : elements) {
            double dst = dstFunc.apply(element);
            if (!(dst < dstClosest)) continue;
            closestElement = element;
            dstClosest = dst;
        }
        return closestElement;
    }
}

