/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Multimap;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;

public class SwordSharpenHelper {
    public static final String NAME_MODIFIER = "swordsharp";
    public static final AttributeModifier MODIFIER_SHARPENED;
    public static List<Class<?>> otherSharpenableSwordSuperClasses;
    public static List<String> blacklistedSharpenableSwordClassNames;

    public static boolean isSwordSharpened(@Nonnull ItemStack stack) {
        if (!SwordSharpenHelper.isSharpenableItem(stack)) {
            return false;
        }
        return NBTHelper.getData(stack).func_74767_n("sharp");
    }

    public static void setSwordSharpened(@Nonnull ItemStack stack) {
        if (!SwordSharpenHelper.isSharpenableItem(stack)) {
            return;
        }
        NBTHelper.getData(stack).func_74757_a("sharp", true);
    }

    public static boolean canBeSharpened(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item i = stack.func_77973_b();
        if (blacklistedSharpenableSwordClassNames.contains(i.getClass().getName())) {
            return false;
        }
        if (SwordSharpenHelper.isSharpenableItem(stack)) {
            return true;
        }
        Class<?> itemClass = stack.func_77973_b().getClass();
        for (Class<?> clazz : otherSharpenableSwordSuperClasses) {
            if (!clazz.isAssignableFrom(itemClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSharpenableItem(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe);
    }

    public static void applySharpenModifier(@Nonnull ItemStack stack, EntityEquipmentSlot slot, Multimap<String, AttributeModifier> map) {
        if (SwordSharpenHelper.isSwordSharpened(stack) && slot.equals((Object)EntityEquipmentSlot.MAINHAND)) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)MODIFIER_SHARPENED);
        }
    }

    static {
        otherSharpenableSwordSuperClasses = new LinkedList();
        blacklistedSharpenableSwordClassNames = new LinkedList<String>();
        MODIFIER_SHARPENED = new AttributeModifier(UUID.fromString("85967b31-db1c-43b9-8d0f-09bceb4e484b"), NAME_MODIFIER, Config.swordSharpMultiplier, 2);
    }
}

