/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

public class NonDuplicateCappedList<T>
implements Iterable<T> {
    private static final Random rand = new Random();
    private List<T> elements = new LinkedList<T>();
    private int cap = 0;

    public NonDuplicateCappedList(int cap) {
        this.cap = cap;
    }

    public boolean offerElement(T element) {
        if (this.elements.size() + 1 > this.cap) {
            return false;
        }
        if (this.elements.contains(element)) {
            return false;
        }
        return this.elements.add(element);
    }

    @Nullable
    public T getRandomElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(rand.nextInt(this.elements.size()));
    }

    @Nullable
    public T getRandomElementByChance(Random rand, float rngMultiplier) {
        if (this.elements.isEmpty()) {
            return null;
        }
        if (Math.max(0, rand.nextInt((int)((float)(this.cap - this.elements.size()) * rngMultiplier) / 2 + 1)) == 0) {
            return this.getRandomElement();
        }
        return null;
    }

    public boolean removeElement(T element) {
        return this.elements.remove(element);
    }

    public void clear() {
        this.elements.clear();
    }

    public int getSize() {
        return this.elements.size();
    }

    public int getCap() {
        return this.cap;
    }

    public void setCap(int cap) {
        this.cap = cap;
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }
}

