/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.util.data.TimeoutList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TimeoutListContainer<K, V>
implements ITickHandler {
    private EnumSet<TickEvent.Type> tickTypes;
    private final ContainerTimeoutDelegate<K, V> delegate;
    private Map<K, TimeoutList<V>> timeoutListMap = new HashMap<K, TimeoutList<V>>();

    public TimeoutListContainer(TickEvent.Type ... restTypes) {
        this((ContainerTimeoutDelegate<K, V>)null, restTypes);
    }

    public TimeoutListContainer(@Nullable ContainerTimeoutDelegate<K, V> delegate, TickEvent.Type ... types) {
        this.tickTypes = EnumSet.noneOf(TickEvent.Type.class);
        for (TickEvent.Type type : types) {
            if (type == null) continue;
            this.tickTypes.add(type);
        }
        this.delegate = delegate;
    }

    public boolean hasList(K key) {
        return this.timeoutListMap.containsKey(key);
    }

    public TimeoutList<V> getOrCreateList(K key) {
        TimeoutList<V> list = this.timeoutListMap.get(key);
        if (list == null) {
            list = new TimeoutList(new RedirectTimeoutDelegate(key, this.delegate), new TickEvent.Type[0]);
            this.timeoutListMap.put(key, list);
        }
        return list;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        Iterator<Map.Entry<K, TimeoutList<V>>> it = this.timeoutListMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, TimeoutList<V>> entry = it.next();
            TimeoutList<V> list = entry.getValue();
            list.tick(type, context);
            if (!list.isEmpty()) continue;
            it.remove();
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return this.tickTypes;
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "TimeoutListContainer";
    }

    public static interface ContainerTimeoutDelegate<K, V> {
        public void onContainerTimeout(K var1, V var2);
    }

    private static class RedirectTimeoutDelegate<K, V>
    implements TimeoutList.TimeoutDelegate<V> {
        private final K key;
        private final ContainerTimeoutDelegate<K, V> delegate;

        private RedirectTimeoutDelegate(K key, @Nullable ContainerTimeoutDelegate<K, V> delegate) {
            this.key = key;
            this.delegate = delegate;
        }

        @Override
        public void onTimeout(V object) {
            if (this.delegate != null) {
                this.delegate.onContainerTimeout(this.key, object);
            }
        }
    }
}

