/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderBrightnessInj
extends WorldProvider {
    private static final Method mInit;
    private static final Method mGenerateLightMap;
    protected final WorldProvider parentOvrProvider;
    protected final World parentWorld;

    public WorldProviderBrightnessInj(World world, WorldProvider parent) {
        this.parentOvrProvider = parent;
        this.parentWorld = world;
        this.func_76558_a(world);
        try {
            if (mInit != null) {
                mInit.invoke((Object)parent, new Object[0]);
            }
            if (mGenerateLightMap != null) {
                mGenerateLightMap.invoke((Object)parent, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private WorldSkyHandler getSkyHandler() {
        return ConstellationSkyHandler.getInstance().getWorldHandler(this.parentWorld);
    }

    public DimensionType func_186058_p() {
        return this.parentOvrProvider.func_186058_p();
    }

    public IChunkGenerator func_186060_c() {
        return this.parentOvrProvider.func_186060_c();
    }

    public WorldBorder func_177501_r() {
        return this.parentOvrProvider.func_177501_r();
    }

    public boolean func_76566_a(int x, int z) {
        return this.parentOvrProvider.func_76566_a(x, z);
    }

    protected void func_76556_a() {
    }

    protected void func_76572_b() {
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return this.parentOvrProvider.func_76563_a(worldTime, partialTicks);
    }

    @Nullable
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return this.parentOvrProvider.func_76560_a(celestialAngle, partialTicks);
    }

    public void calculateInitialWeather() {
        this.parentOvrProvider.calculateInitialWeather();
    }

    public double getMovementFactor() {
        return this.parentOvrProvider.getMovementFactor();
    }

    public boolean canDoLightning(Chunk chunk) {
        return this.parentOvrProvider.canDoLightning(chunk);
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        return this.parentOvrProvider.getBiomeForCoords(pos);
    }

    public BiomeProvider func_177499_m() {
        return this.parentOvrProvider.func_177499_m();
    }

    public BlockPos getRandomizedSpawnPoint() {
        return this.parentOvrProvider.getRandomizedSpawnPoint();
    }

    public BlockPos func_177496_h() {
        return this.parentOvrProvider.func_177496_h();
    }

    public BlockPos getSpawnPoint() {
        return this.parentOvrProvider.getSpawnPoint();
    }

    public boolean func_177495_o() {
        return this.parentOvrProvider.func_177495_o();
    }

    public double getHorizon() {
        return this.parentOvrProvider.getHorizon();
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float parTicks) {
        WorldSkyHandler handle = this.getSkyHandler();
        if (handle != null) {
            float sunBr = this.parentWorld.getSunBrightnessBody(parTicks);
            int eclTick = handle.solarEclipseTick;
            eclTick = eclTick >= 2400 ? (eclTick -= 2400) : 2400 - eclTick;
            float perc = (float)eclTick / 2400.0f;
            return sunBr * (0.15f + 0.85f * perc);
        }
        return this.parentWorld.getSunBrightnessBody(parTicks);
    }

    public float getSunBrightnessFactor(float parTicks) {
        WorldSkyHandler handle = this.getSkyHandler();
        if (handle != null && handle.dayOfSolarEclipse && handle.solarEclipse) {
            float sunBr = this.parentWorld.getSunBrightnessFactor(parTicks);
            int eclTick = handle.solarEclipseTick;
            eclTick = eclTick >= 2400 ? (eclTick -= 2400) : 2400 - eclTick;
            float perc = (float)eclTick / 2400.0f;
            return sunBr * (0.15f + 0.85f * perc);
        }
        return this.parentWorld.getSunBrightnessFactor(parTicks);
    }

    public double func_76565_k() {
        return this.parentOvrProvider.func_76565_k();
    }

    public float func_76571_f() {
        return this.parentOvrProvider.func_76571_f();
    }

    public float getCurrentMoonPhaseFactor() {
        return this.parentOvrProvider.getCurrentMoonPhaseFactor();
    }

    public float getStarBrightness(float par1) {
        return this.parentOvrProvider.getStarBrightness(par1);
    }

    public float[] func_177497_p() {
        return this.parentOvrProvider.func_177497_p();
    }

    public int getActualHeight() {
        return this.parentOvrProvider.getActualHeight();
    }

    public int func_76557_i() {
        return this.parentOvrProvider.func_76557_i();
    }

    public int getDimension() {
        return this.parentOvrProvider.getDimension();
    }

    public int getHeight() {
        return this.parentOvrProvider.getHeight();
    }

    public int func_76559_b(long worldTime) {
        return this.parentOvrProvider.func_76559_b(worldTime);
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.parentOvrProvider.getRespawnDimension(player);
    }

    public IRenderHandler getCloudRenderer() {
        return this.parentOvrProvider.getCloudRenderer();
    }

    public IRenderHandler getSkyRenderer() {
        return this.parentOvrProvider.getSkyRenderer();
    }

    public IRenderHandler getWeatherRenderer() {
        return this.parentOvrProvider.getWeatherRenderer();
    }

    public long getSeed() {
        return this.parentOvrProvider.getSeed();
    }

    public long getWorldTime() {
        return this.parentOvrProvider.getWorldTime();
    }

    public String getSaveFolder() {
        return this.parentOvrProvider.getSaveFolder();
    }

    public Vec3d getCloudColor(float partialTicks) {
        return this.parentOvrProvider.getCloudColor(partialTicks);
    }

    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return this.parentOvrProvider.func_76562_b(p_76562_1_, p_76562_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        if (cameraEntity == null) {
            cameraEntity = Minecraft.func_71410_x().field_71439_g;
        }
        return this.parentOvrProvider.getSkyColor(cameraEntity, partialTicks);
    }

    public boolean func_186056_c(int x, int z) {
        return this.parentOvrProvider.func_186056_c(x, z);
    }

    public boolean canBlockFreeze(BlockPos pos, boolean byWater) {
        return this.parentOvrProvider.canBlockFreeze(pos, byWater);
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.parentOvrProvider.canDoRainSnowIce(chunk);
    }

    public boolean canMineBlock(EntityPlayer player, BlockPos pos) {
        return this.parentOvrProvider.canMineBlock(player, pos);
    }

    public boolean func_76567_e() {
        return this.parentOvrProvider.func_76567_e();
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        return this.parentOvrProvider.canSnowAt(pos, checkLight);
    }

    public boolean func_76561_g() {
        return this.parentOvrProvider.func_76561_g();
    }

    public ICapabilityProvider initCapabilities() {
        return this.parentOvrProvider.initCapabilities();
    }

    public void setCloudRenderer(IRenderHandler renderer) {
        this.parentOvrProvider.setCloudRenderer(renderer);
    }

    public void resetRainAndThunder() {
        this.parentOvrProvider.resetRainAndThunder();
    }

    public void func_186062_b(EntityPlayerMP player) {
        this.parentOvrProvider.func_186062_b(player);
    }

    public void setSkyRenderer(IRenderHandler skyRenderer) {
        this.parentOvrProvider.setSkyRenderer(skyRenderer);
    }

    public void setWeatherRenderer(IRenderHandler renderer) {
        this.parentOvrProvider.setWeatherRenderer(renderer);
    }

    public boolean func_177500_n() {
        return this.parentOvrProvider.func_177500_n();
    }

    public boolean isDaytime() {
        WorldSkyHandler handle = this.getSkyHandler();
        if (handle != null && handle.dayOfSolarEclipse && handle.solarEclipse) {
            return true;
        }
        return this.parentOvrProvider.isDaytime();
    }

    public boolean func_76568_b(int x, int z) {
        return this.parentOvrProvider.func_76568_b(x, z);
    }

    public void setDimension(int dim) {
        this.parentOvrProvider.setDimension(dim);
    }

    public boolean func_76569_d() {
        return this.parentOvrProvider.func_76569_d();
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return this.parentOvrProvider.isBlockHighHumidity(pos);
    }

    public void func_186059_r() {
        this.parentOvrProvider.func_186059_r();
    }

    public void func_186057_q() {
        this.parentOvrProvider.func_186057_q();
    }

    public void func_186061_a(EntityPlayerMP player) {
        this.parentOvrProvider.func_186061_a(player);
    }

    public void setSpawnPoint(BlockPos pos) {
        this.parentOvrProvider.setSpawnPoint(pos);
    }

    public void setWorldTime(long time) {
        this.parentOvrProvider.setWorldTime(time);
    }

    public void updateWeather() {
        this.parentOvrProvider.updateWeather();
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
        this.parentOvrProvider.setAllowedSpawnTypes(allowHostile, allowPeaceful);
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return this.parentOvrProvider.shouldMapSpin(entity, x, y, z);
    }

    public boolean func_191066_m() {
        return this.parentOvrProvider.func_191066_m();
    }

    static {
        Method init = null;
        Method generateLightMap = null;
        try {
            init = ReflectionHelper.findMethod(WorldProvider.class, (String)"init", (String)"func_76572_b", (Class[])new Class[0]);
            generateLightMap = ReflectionHelper.findMethod(WorldProvider.class, (String)"generateLightBrightnessTable", (String)"func_76556_a", (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mInit = init;
        mGenerateLightMap = generateLightMap;
    }
}

