/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.forestry;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAddForestry;
import com.blamejared.mtlib.utils.BaseRemoveForestry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.SqueezerRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Squeezer")
@ModOnly(value="forestry")
@ZenRegister
public class Squeezer {
    public static final String name = "Forestry Squeezer";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack[] ingredients, int timePerItem, @Optional WeightedItemStack itemOutput) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add((ISqueezerRecipe)new SqueezerRecipe(timePerItem, InputHelper.toNonNullList((Object[])InputHelper.toStacks((IItemStack[])ingredients)), InputHelper.toFluid((ILiquidStack)fluidOutput), itemOutput != null ? InputHelper.toStack((IItemStack)itemOutput.getStack()) : ItemStack.field_190927_a, itemOutput != null ? itemOutput.getChance() : 0.0f)));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack liquid, @Optional IIngredient[] ingredients) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(liquid, ingredients));
    }

    private static class Remove
    extends BaseRemoveForestry<ISqueezerRecipe> {
        private final ILiquidStack liquid;
        private final IIngredient[] ingredients;

        public Remove(ILiquidStack liquid, IIngredient[] ingredients) {
            super(Squeezer.name, (ICraftingProvider)RecipeManagers.squeezerManager);
            this.liquid = liquid;
            this.ingredients = ingredients;
        }

        public String getRecipeInfo() {
            return this.liquid.getDisplayName();
        }

        public boolean checkIsRecipe(ISqueezerRecipe recipe) {
            if (this.ingredients != null) {
                boolean matched = false;
                for (int i = 0; i < this.ingredients.length; ++i) {
                    if (!StackHelper.matches((IIngredient)this.ingredients[i], (IItemStack)InputHelper.toIItemStack((ItemStack)((ItemStack)recipe.getResources().get(i))))) {
                        matched = false;
                        break;
                    }
                    matched = true;
                }
                return matched;
            }
            return true;
        }
    }

    private static class Add
    extends BaseAddForestry<ISqueezerRecipe> {
        public Add(ISqueezerRecipe recipe) {
            super(Squeezer.name, (ICraftingProvider)RecipeManagers.squeezerManager, (IForestryRecipe)recipe);
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)((ISqueezerRecipe)this.recipe).getFluidOutput());
        }
    }
}

