/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.forestry;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAddForestry;
import com.blamejared.mtlib.utils.BaseRemoveForestry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.IStillRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.StillRecipe;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Still")
@ModOnly(value="forestry")
@ZenRegister
public class Still {
    public static final String name = "Forestry Still";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, ILiquidStack fluidInput, int timePerUnit) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add((IStillRecipe)new StillRecipe(timePerUnit, InputHelper.toFluid((ILiquidStack)fluidInput), InputHelper.toFluid((ILiquidStack)fluidOutput))));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output, @Optional ILiquidStack fluidInput) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output, fluidInput));
    }

    private static class Remove
    extends BaseRemoveForestry<IStillRecipe> {
        private final ILiquidStack output;
        private final ILiquidStack fluidInput;

        public Remove(ILiquidStack output, ILiquidStack fluidInput) {
            super(Still.name, (ICraftingProvider)RecipeManagers.stillManager);
            this.output = output;
            this.fluidInput = fluidInput;
        }

        public String getRecipeInfo() {
            return this.fluidInput != null ? this.fluidInput.getDisplayName() + " --> " : "" + this.output.getDisplayName();
        }

        public boolean checkIsRecipe(IStillRecipe r) {
            if (r != null && StackHelper.matches((IIngredient)this.output, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)r.getOutput()))) {
                if (this.fluidInput != null) {
                    if (StackHelper.matches((IIngredient)this.fluidInput, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)r.getInput()))) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
    }

    private static class Add
    extends BaseAddForestry<IStillRecipe> {
        public Add(IStillRecipe recipe) {
            super(Still.name, (ICraftingProvider)RecipeManagers.stillManager, (IForestryRecipe)recipe);
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)((IStillRecipe)this.recipe).getOutput());
        }
    }
}

