/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.AlloyRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Alloy")
@ZenRegister
@ModOnly(value="tconstruct")
public class Alloy {
    public static final List<ILiquidStack> REMOVED_RECIPES = new LinkedList<ILiquidStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Alloy());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack[] inputs) {
        Alloy.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toFluids((ILiquidStack[])inputs)));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output) {
        Alloy.init();
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.AlloyRegisterEvent event) {
        if (event.getRecipe() instanceof AlloyRecipeTweaker) {
            return;
        }
        for (ILiquidStack stack : REMOVED_RECIPES) {
            if (!((AlloyRecipe)event.getRecipe()).getResult().isFluidEqual((FluidStack)stack.getInternal())) continue;
            event.setCanceled(true);
        }
    }

    private static class Remove
    extends BaseUndoable {
        private ILiquidStack output;

        protected Remove(ILiquidStack output) {
            super("Alloy");
            this.output = output;
        }

        public void apply() {
            REMOVED_RECIPES.add(this.output);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class Add
    extends BaseUndoable {
        private FluidStack output;
        private FluidStack[] input;

        public Add(FluidStack output, FluidStack[] input) {
            super("Alloy");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            TinkerRegistry.registerAlloy((AlloyRecipe)new AlloyRecipeTweaker(this.output, this.input));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

