/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.DryingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Drying")
@ZenRegister
@ModOnly(value="tconstruct")
public class Drying {
    public static final List<IItemStack> DRYING_RECIPES = new LinkedList<IItemStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Drying());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int time) {
        Drying.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), InputHelper.toStack((IItemStack)input), time));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        Drying.init();
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.DryingRackRegisterEvent event) {
        if (event.getRecipe() instanceof DryingRecipeTweaker) {
            return;
        }
        for (IItemStack stack : DRYING_RECIPES) {
            if (!stack.matches(InputHelper.toIItemStack((ItemStack)((DryingRecipe)event.getRecipe()).getResult()))) continue;
            event.setCanceled(true);
        }
    }

    private static class Remove
    extends BaseUndoable {
        private IItemStack output;

        protected Remove(IItemStack output) {
            super("Drying");
            this.output = output;
        }

        public void apply() {
            DRYING_RECIPES.add(this.output);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class Add
    extends BaseUndoable {
        private ItemStack output;
        private ItemStack input;
        private int time;

        public Add(ItemStack output, ItemStack input, int time) {
            super("Drying");
            this.output = output;
            this.input = input;
            this.time = time;
        }

        public void apply() {
            TinkerRegistry.addDryingRecipe((DryingRecipe)new DryingRecipeTweaker((RecipeMatch)new RecipeMatch.Item(this.input, 1), this.output, this.time));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }
}

