/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.MeltingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Melting")
@ZenRegister
@ModOnly(value="tconstruct")
public class Melting {
    public static final List<ILiquidStack> REMOVED_RECIPES = new LinkedList<ILiquidStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Melting());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack output, IItemStack input, @Optional int temp) {
        Melting.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toStack((IItemStack)input), temp));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output) {
        Melting.init();
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.MeltingRegisterEvent event) {
        if (event.getRecipe() instanceof MeltingRecipeTweaker) {
            return;
        }
        for (ILiquidStack stack : REMOVED_RECIPES) {
            if (!((MeltingRecipe)event.getRecipe()).getResult().isFluidEqual((FluidStack)stack.getInternal())) continue;
            event.setCanceled(true);
        }
    }

    private static class Remove
    extends BaseUndoable {
        private ILiquidStack output;

        protected Remove(ILiquidStack output) {
            super("Melting");
            this.output = output;
        }

        public void apply() {
            REMOVED_RECIPES.add(this.output);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class Add
    extends BaseUndoable {
        private FluidStack output;
        private ItemStack input;
        private int temp;

        public Add(FluidStack output, ItemStack input, int temp) {
            super("Melting");
            this.output = output;
            this.input = input;
            this.temp = temp;
        }

        public void apply() {
            if (this.temp != 0) {
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipeTweaker(RecipeMatch.of((ItemStack)this.input, (int)this.output.amount), this.output, this.temp));
            } else {
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipeTweaker(RecipeMatch.of((ItemStack)this.input, (int)this.output.amount), this.output));
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

