/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.block;

import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.block.AFBaseBlock;
import com.thiakil.appliedfluidics.client.render.TankFluidRenderer;
import com.thiakil.appliedfluidics.item.ItemBlockCertusTank;
import com.thiakil.appliedfluidics.tile.TileCertusTank;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCertusTank
extends AFBaseBlock {
    public static BlockCertusTank INSTANCE;
    public static ItemBlockCertusTank myItemblock;

    public BlockCertusTank() {
        super(Material.field_151573_f, "certus_tank");
        this.setOpaque(false);
        this.func_149713_g(1);
        GameRegistry.registerTileEntity(TileCertusTank.class, (String)("appliedfluidics:" + TileCertusTank.class.getName()));
    }

    @Override
    protected void createItem() {
        myItemblock = new ItemBlockCertusTank((Block)this);
        this.myItem = myItemblock;
        this.myItem.setRegistryName(this.getRegistryName());
    }

    private ItemStack getTileAsItemStack(IBlockAccess world, BlockPos pos) {
        ItemStack itemDropped = new ItemStack((Item)myItemblock, 1);
        TileCertusTank myTile = (TileCertusTank)world.func_175625_s(pos);
        try {
            IFluidHandlerItem handler;
            FluidStack contents;
            if (myTile != null && (contents = myTile.getContents()) != null && (handler = (IFluidHandlerItem)itemDropped.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                handler.fill(contents, true);
                itemDropped = handler.getContainer();
            }
        }
        catch (Throwable t) {
            FluidicsMod.logger.error("Couldn't set itemstack's fluid :(", t);
        }
        return itemDropped;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(this.getTileAsItemStack(world, pos));
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getTileAsItemStack((IBlockAccess)world, pos);
    }

    public void func_180633_a(World w, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack is) {
        super.func_180633_a(w, pos, state, placer, is);
        TileEntity tile = w.func_175625_s(pos);
        if (tile != null && tile instanceof TileCertusTank) {
            ((TileCertusTank)tile).placed(is);
        }
    }

    public boolean func_180639_a(World w, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() || FluidUtil.getFluidHandler((ItemStack)heldItem) == null) {
            return super.func_180639_a(w, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        if (!w.field_72995_K) {
            TileEntity tile = w.func_175625_s(pos);
            if (tile != null && tile instanceof TileCertusTank) {
                ((TileCertusTank)tile).onBlockActivated(w, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
            } else {
                FluidicsMod.logger.error("Not my tile, not my circus.");
            }
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        FluidStack contents;
        if (state.func_177230_c() != this) {
            return state.func_177230_c().getLightValue(state, world, pos);
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileCertusTank && (contents = ((TileCertusTank)tile).getContents()) != null) {
            return (int)((float)contents.getFluid().getLuminosity(contents) * ((float)contents.amount / (float)TileCertusTank.CAPACITY));
        }
        return 0;
    }

    @Override
    public void setInstance(AFBaseBlock instance) {
        INSTANCE = (BlockCertusTank)instance;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCertusTank();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemRender() {
        super.registerItemRender();
        ClientRegistry.bindTileEntitySpecialRenderer(TileCertusTank.class, (TileEntitySpecialRenderer)new TankFluidRenderer.CertusTank());
    }
}

