/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.client.gui;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.AEBaseGui;
import appeng.container.slot.AppEngSlot;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.client.gui.GuiMEMonitorableFluid;
import com.thiakil.appliedfluidics.client.render.StackSizeRendererFluid;
import com.thiakil.appliedfluidics.container.ContainerMEMonitorableFluid;
import com.thiakil.appliedfluidics.container.slot.IFluidSlot;
import com.thiakil.appliedfluidics.container.slot.SlotMEFluid;
import com.thiakil.appliedfluidics.container.slot.SlotNoDisplay;
import com.thiakil.appliedfluidics.item.ItemFluidDrop;
import com.thiakil.appliedfluidics.util.FluidRenderer;
import com.thiakil.appliedfluidics.util.ModNames;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public abstract class GuiFluid
extends AEBaseGui {
    private final StackSizeRendererFluid stackSizeRenderer = new StackSizeRendererFluid();
    private static final NumberFormat nf = NumberFormat.getInstance();

    public GuiFluid(Container container) {
        super(container);
    }

    protected boolean renderFluidToolTip(ItemStack stack, int x, int y) {
        Slot slot;
        if (stack.func_77973_b() != ItemFluidDrop.INSTANCE) {
            return false;
        }
        FluidStack fs = ItemFluidDrop.getFluidStackFromStack(stack);
        if (fs == null) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(fs.getLocalizedName());
        if (this instanceof GuiMEMonitorableFluid && (slot = this.getSlot(x, y)) != null && slot instanceof SlotMEFluid) {
            IAEFluidStack aeStack = ((SlotMEFluid)slot).getAEStack();
            String amount = nf.format(aeStack.getStackSize()) + "mb";
            if (aeStack.getCountRequestable() > 0L) {
                amount = amount + " (" + nf.format(aeStack.getCountRequestable()) + "mb requestable)";
            }
            list.add(amount);
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        list.add(TextFormatting.BLUE + ModNames.getModNameFromFluid(fs.getFluid()));
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
        return true;
    }

    public void func_146977_a(Slot s) {
        if (s instanceof SlotMEFluid) {
            try {
                this.field_73735_i = 100.0f;
                this.field_146296_j.field_77023_b = 100.0f;
                if (!this.isPowered()) {
                    GuiFluid.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
                }
                this.field_73735_i = 0.0f;
                this.field_146296_j.field_77023_b = 0.0f;
                this.drawFluidSlot(s);
                this.stackSizeRenderer.renderStackSize(this.field_146289_q, ((SlotMEFluid)s).getAEStack(), s.func_75211_c(), s.field_75223_e, s.field_75221_f);
            }
            catch (Exception err) {
                FluidicsMod.logger.error("Prevented crash while drawing slot: ", (Throwable)err);
            }
            return;
        }
        if (s instanceof IFluidSlot) {
            this.drawFluidSlot(s);
            return;
        }
        super.func_146977_a(s);
    }

    protected void drawFluidSlot(Slot s) {
        if (s instanceof IFluidSlot) {
            if (s instanceof AppEngSlot && !((AppEngSlot)s).shouldDisplay()) {
                return;
            }
            super.func_146977_a((Slot)new SlotNoDisplay(s));
            FluidStack fs = ((IFluidSlot)s).getFluidStack();
            if (fs != null) {
                FluidRenderer.render(this.field_146297_k, s.field_75223_e, s.field_75221_f, fs);
            }
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        if (this.getSlotUnderMouse() != null && this.getSlotUnderMouse() instanceof IFluidSlot) {
            this.renderFluidToolTip(stack, x, y);
        } else {
            super.func_146285_a(stack, x, y);
        }
    }

    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof SlotMEFluid) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            InventoryAction action = null;
            IAEFluidStack stack = ((SlotMEFluid)slot).getAEStack();
            switch (clickType) {
                case PICKUP: {
                    InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    if (!player.field_71071_by.func_70445_o().func_190926_b()) break;
                    return;
                }
            }
            if (action != null) {
                ((ContainerMEMonitorableFluid)this.field_147002_h).setTargetFluidStack(stack);
                PacketInventoryAction p = new PacketInventoryAction(action, slot.getSlotIndex(), 0L);
                NetworkHandler.instance().sendToServer((AppEngPacket)p);
            }
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }
}

