/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.client.gui;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.client.gui.GuiFluid;
import com.thiakil.appliedfluidics.container.ContainerMEMonitorableFluid;
import com.thiakil.appliedfluidics.container.slot.InternalSlotMEFluid;
import com.thiakil.appliedfluidics.container.slot.SlotMEFluid;
import com.thiakil.appliedfluidics.helpers.FluidRepo;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiMEMonitorableFluid
extends GuiFluid
implements ISortSource,
IConfigManagerHost {
    private static int craftingGridOffsetX;
    private static int craftingGridOffsetY;
    private static String memoryText;
    private final FluidRepo repo;
    private final int offsetX = 9;
    private final int lowerTextureOffset = 0;
    private final IConfigManager configSrc;
    private final boolean viewCell;
    private final ItemStack[] myCurrentViewCells = new ItemStack[5];
    private final ContainerMEMonitorableFluid monitorableContainer;
    private GuiTabButton craftingStatusBtn;
    private MEGuiTextField searchField;
    private String myName = "???";
    private int perRow = 9;
    private int reservedSpace = 0;
    private boolean customSortOrder = true;
    private int rows = 0;
    private int maxRows = Integer.MAX_VALUE;
    private int standardSize;
    private GuiImgButton ViewBox;
    private GuiImgButton SortByBox;
    private GuiImgButton SortDirBox;
    private GuiImgButton searchBoxSettings;
    private GuiImgButton terminalStyleBox;
    private final List<InternalSlotMEFluid> meSlots = new LinkedList<InternalSlotMEFluid>();

    public GuiMEMonitorableFluid(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        this(inventoryPlayer, te, new ContainerMEMonitorableFluid(inventoryPlayer, te));
    }

    public GuiMEMonitorableFluid(InventoryPlayer inventoryPlayer, ITerminalHost te, ContainerMEMonitorableFluid c) {
        super((Container)c);
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new FluidRepo((IScrollSource)scrollbar, this);
        this.field_146999_f = 185;
        this.field_147000_g = 204;
        if (te instanceof IViewCellStorage) {
            this.field_146999_f += 33;
        }
        this.standardSize = this.field_146999_f;
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        this.monitorableContainer = (ContainerMEMonitorableFluid)this.field_147002_h;
        this.monitorableContainer.setGui(this);
        this.viewCell = te instanceof IViewCellStorage;
        if (te instanceof AbstractPartTerminal) {
            this.myName = I18n.func_135052_a((String)"appliedfluidics.part.fluid_terminal.name", (Object[])new Object[0]);
        }
    }

    public void postUpdate(List<IAEFluidStack> list) {
        this.repo.postUpdate(list);
        this.repo.updateView(false);
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
        this.getScrollBar().setRange(0, (this.repo.size() + this.perRow - 1) / this.perRow - this.rows, Math.max(1, this.rows / 6));
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == this.craftingStatusBtn) {
            NetworkHandler.instance().sendToServer((AppEngPacket)new PacketSwitchGuis(GuiBridge.GUI_CRAFTING_STATUS));
        }
        if (btn instanceof GuiImgButton) {
            boolean backwards = Mouse.isButtonDown((int)1);
            GuiImgButton iBtn = (GuiImgButton)btn;
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn.getSetting().getPossibleValues());
                if (btn == this.terminalStyleBox) {
                    AEConfig.instance().getConfigManager().putSetting(iBtn.getSetting(), next);
                } else if (btn == this.searchBoxSettings) {
                    AEConfig.instance().getConfigManager().putSetting(iBtn.getSetting(), next);
                } else {
                    try {
                        NetworkHandler.instance().sendToServer((AppEngPacket)new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                }
                iBtn.set(next);
                if (next.getClass() == SearchBoxMode.class || next.getClass() == TerminalStyle.class) {
                    this.reinitalize();
                }
            }
        }
    }

    private void reinitalize() {
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.maxRows = this.getMaxRows();
        this.perRow = AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.FULL ? 9 : 9 + (this.field_146294_l - this.standardSize) / 18;
        int magicNumber = 115;
        int extraSpace = this.field_146295_m - 115 - this.reservedSpace;
        this.rows = (int)Math.floor(extraSpace / 18);
        if (this.rows > this.maxRows) {
            this.rows = this.maxRows;
        }
        if (this.rows < 3) {
            this.rows = 3;
        }
        this.meSlots.clear();
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.perRow; ++x) {
                this.meSlots.add(new InternalSlotMEFluid(this.repo, x + y * this.perRow, this.offsetX + x * 18, 18 + y * 18));
            }
        }
        this.field_146999_f = AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.FULL ? this.standardSize + (this.perRow - 9) * 18 : this.standardSize;
        super.func_73866_w_();
        List slots = this.field_147002_h.field_75151_b;
        Iterator i = slots.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof SlotMEFluid)) continue;
            i.remove();
        }
        for (InternalSlotMEFluid me : this.meSlots) {
            slots.add(new SlotMEFluid(me, slots.size()));
        }
        this.field_147000_g = 115 + this.rows * 18 + this.reservedSpace;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        int offset = this.field_147009_r + 8;
        if (this.customSortOrder) {
            this.SortByBox = new GuiImgButton(this.field_147003_i - 18, offset, (Enum)Settings.SORT_BY, this.configSrc.getSetting(Settings.SORT_BY));
            this.field_146292_n.add(this.SortByBox);
            offset += 20;
        }
        if (this.viewCell) {
            this.ViewBox = new GuiImgButton(this.field_147003_i - 18, offset, (Enum)Settings.VIEW_MODE, this.configSrc.getSetting(Settings.VIEW_MODE));
            this.field_146292_n.add(this.ViewBox);
            offset += 20;
        }
        this.SortDirBox = new GuiImgButton(this.field_147003_i - 18, offset, (Enum)Settings.SORT_DIRECTION, this.configSrc.getSetting(Settings.SORT_DIRECTION));
        this.field_146292_n.add(this.SortDirBox);
        this.searchBoxSettings = new GuiImgButton(this.field_147003_i - 18, offset += 20, (Enum)Settings.SEARCH_MODE, AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE));
        this.field_146292_n.add(this.searchBoxSettings);
        this.terminalStyleBox = new GuiImgButton(this.field_147003_i - 18, offset += 20, (Enum)Settings.TERMINAL_STYLE, AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.add(this.terminalStyleBox);
        this.searchField = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(80, this.offsetX), this.field_147009_r + 4, 90, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146189_e(true);
        Enum setting = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE);
        this.searchField.func_146195_b(SearchBoxMode.AUTOSEARCH == setting || SearchBoxMode.JEI_AUTOSEARCH == setting);
        if (this.isSubGui()) {
            this.searchField.func_146180_a(memoryText);
            this.repo.setSearchString(memoryText);
            this.repo.updateView();
            this.setScrollBar();
        }
        craftingGridOffsetX = Integer.MAX_VALUE;
        craftingGridOffsetY = Integer.MAX_VALUE;
        for (Object s : this.field_147002_h.field_75151_b) {
            if (s instanceof AppEngSlot && ((Slot)s).field_75223_e < 197) {
                this.repositionSlot((AppEngSlot)s);
            }
            if (!(s instanceof SlotCraftingMatrix) && !(s instanceof SlotFakeCraftingMatrix)) continue;
            Slot g = (Slot)s;
            if (g.field_75223_e <= 0 || g.field_75221_f <= 0) continue;
            craftingGridOffsetX = Math.min(craftingGridOffsetX, g.field_75223_e);
            craftingGridOffsetY = Math.min(craftingGridOffsetY, g.field_75221_f);
        }
        craftingGridOffsetX -= 25;
        craftingGridOffsetY -= 6;
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.myName, 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        Enum searchMode = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE);
        if (searchMode != SearchBoxMode.AUTOSEARCH && searchMode != SearchBoxMode.JEI_AUTOSEARCH) {
            this.searchField.func_146192_a(xCoord, yCoord, btn);
        }
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        memoryText = this.searchField.func_146179_b();
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture(this.getBackground());
        int x_width = 197;
        this.func_73729_b(offsetX, offsetY, 0, 0, 197, 18);
        if (this.viewCell) {
            this.func_73729_b(offsetX + 197, offsetY, 197, 0, 46, 128);
        }
        for (int x = 0; x < this.rows; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.func_73729_b(offsetX, offsetY + 16 + this.rows * 18 + this.lowerTextureOffset, 0, 70, 197, 99 + this.reservedSpace - this.lowerTextureOffset);
        if (this.viewCell) {
            boolean update = false;
            for (int i = 0; i < 5; ++i) {
                if (this.myCurrentViewCells[i] == this.monitorableContainer.getCellViewSlot(i).func_75211_c()) continue;
                update = true;
                this.myCurrentViewCells[i] = this.monitorableContainer.getCellViewSlot(i).func_75211_c();
            }
            if (update) {
                this.repo.setViewCell(this.myCurrentViewCells);
            }
        }
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }

    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    int getMaxRows() {
        return AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
    }

    protected void repositionSlot(AppEngSlot s) {
        s.field_75221_f = s.getY() + this.field_147000_g - 78 - 5;
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.repo.setSearchString(this.searchField.func_146179_b());
                this.repo.updateView();
                this.setScrollBar();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    public void func_73876_c() {
        this.repo.setPower(this.monitorableContainer.isPowered());
        super.func_73876_c();
    }

    public Enum getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    public Enum getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    public Enum getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.SortByBox != null) {
            this.SortByBox.set(this.configSrc.getSetting(Settings.SORT_BY));
        }
        if (this.SortDirBox != null) {
            this.SortDirBox.set(this.configSrc.getSetting(Settings.SORT_DIRECTION));
        }
        if (this.ViewBox != null) {
            this.ViewBox.set(this.configSrc.getSetting(Settings.VIEW_MODE));
        }
        this.repo.updateView();
    }

    int getReservedSpace() {
        return this.reservedSpace;
    }

    void setReservedSpace(int reservedSpace) {
        this.reservedSpace = reservedSpace;
    }

    public boolean isCustomSortOrder() {
        return this.customSortOrder;
    }

    void setCustomSortOrder(boolean customSortOrder) {
        this.customSortOrder = customSortOrder;
    }

    public int getStandardSize() {
        return this.standardSize;
    }

    void setStandardSize(int standardSize) {
        this.standardSize = standardSize;
    }

    static {
        memoryText = "";
    }
}

