/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.apache.commons.lang3.tuple.Pair;

public final class ModelQuartzBucket
implements IModel {
    public static final ModelResourceLocation LOCATION_CERTUS = new ModelResourceLocation(new ResourceLocation("appliedfluidics", "certus_bucket"), "inventory");
    public static final ModelResourceLocation LOCATION_NETHER = new ModelResourceLocation(new ResourceLocation("appliedfluidics", "nether_bucket"), "inventory");
    private static final float NORTH_Z_BASE = 0.4685f;
    private static final float SOUTH_Z_BASE = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL_CERTUS = new ModelQuartzBucket(new ResourceLocation("appliedfluidics:items/certus_bucket_base"), new ResourceLocation("forge:items/bucket_fluid"), new ResourceLocation("appliedfluidics:items/certus_bucket_cover"), null, false);
    public static final IModel MODEL_NETHER = new ModelQuartzBucket(new ResourceLocation("appliedfluidics:items/nether_bucket_base"), new ResourceLocation("forge:items/bucket_fluid"), new ResourceLocation("appliedfluidics:items/nether_bucket_cover"), null, false);
    @Nullable
    private final ResourceLocation baseLocation;
    @Nullable
    private final ResourceLocation liquidLocation;
    @Nullable
    private final ResourceLocation coverLocation;
    @Nullable
    private final Fluid fluid;
    private final boolean flipGas;

    public ModelQuartzBucket() {
        this(null, null, null, null, false);
    }

    public ModelQuartzBucket(@Nullable ResourceLocation baseLocation, @Nullable ResourceLocation liquidLocation, @Nullable ResourceLocation coverLocation, @Nullable Fluid fluid, boolean flipGas) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        if (this.flipGas && this.fluid != null && this.fluid.isGaseous()) {
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = bakedTextureGetter.apply(this.liquidLocation);
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)this.fluid.getColor()));
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)this.fluid.getColor()));
        }
        if (this.coverLocation != null) {
            TextureAtlasSprite base = bakedTextureGetter.apply(this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4685f, (TextureAtlasSprite)base, (EnumFacing)EnumFacing.NORTH, (int)-1));
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5315f, (TextureAtlasSprite)base, (EnumFacing)EnumFacing.SOUTH, (int)-1));
        }
        IModel generated = null;
        try {
            generated = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("item/generated"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new BakedQuartzBucket(this, (ImmutableList<BakedQuad>)builder.build(), fluidSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap(), generated != null ? generated.bake(state, format, bakedTextureGetter) : null);
    }

    public ModelQuartzBucket process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        return new ModelQuartzBucket(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip);
    }

    public ModelQuartzBucket retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        ResourceLocation liquid = this.liquidLocation;
        ResourceLocation cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new ResourceLocation((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new ResourceLocation((String)textures.get((Object)"cover"));
        }
        return new ModelQuartzBucket(base, liquid, cover, this.fluid, this.flipGas);
    }

    private static final class BakedQuartzBucket
    implements IBakedModel {
        private final ModelQuartzBucket parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;
        private final IBakedModel generated;

        public BakedQuartzBucket(ModelQuartzBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache, IBakedModel generated) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
            this.generated = generated;
        }

        public ItemOverrideList func_188617_f() {
            return BakedQuartzBucketOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (this.generated != null) {
                return Pair.of((Object)this, (Object)this.generated.handlePerspective(cameraTransformType).getRight());
            }
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }
    }

    private static final class BakedQuartzBucketOverrideHandler
    extends ItemOverrideList {
        public static final BakedQuartzBucketOverrideHandler INSTANCE = new BakedQuartzBucketOverrideHandler();

        private BakedQuartzBucketOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidStack == null) {
                return originalModel;
            }
            BakedQuartzBucket model = (BakedQuartzBucket)originalModel;
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!model.cache.containsKey(name)) {
                IModel parent = model.parent.process(ImmutableMap.of((Object)"fluid", (Object)name, (Object)"flipGas", (Object)new Boolean(fluid.isGaseous()).toString()));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.format, textureGetter);
                model.cache.put(name, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(name);
        }
    }

    public static enum LoaderQuartzBucket implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("appliedfluidics") && modelLocation.func_110623_a().contains("_bucket");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return modelLocation.func_110623_a().contains("nether") ? MODEL_NETHER : MODEL_CERTUS;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

