/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.container;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.util.iterators.NullIterator;
import com.thiakil.appliedfluidics.container.ContainerFluidUpgradeable;
import com.thiakil.appliedfluidics.container.slot.FluidOptionalSlotFakeTypeOnly;
import com.thiakil.appliedfluidics.container.slot.FluidSlotFakeTypeOnly;
import com.thiakil.appliedfluidics.part.PartFluidStorage;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerFluidStorageBus
extends ContainerFluidUpgradeable {
    private final PartFluidStorage storageBus;
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;

    public ContainerFluidStorageBus(InventoryPlayer ip, PartFluidStorage te) {
        super(ip, (IUpgradeableHost)te);
        this.storageBus = te;
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    protected void setupConfig() {
        int xo = 8;
        int yo = 29;
        IInventory config = this.getUpgradeable().getInventoryByName("config");
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (y < 2) {
                    this.func_75146_a((Slot)new FluidSlotFakeTypeOnly(config, y * 9 + x, 8 + x * 18, 29 + y * 18));
                    continue;
                }
                this.func_75146_a((Slot)new FluidOptionalSlotFakeTypeOnly(config, this, y * 9 + x, 8, 29, x, y, y - 2));
            }
        }
        IInventory upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 4, 187, 80, this.getInventoryPlayer()).setNotDraggable());
    }

    @Override
    protected boolean supportCapacity() {
        return true;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
        this.setReadWriteMode((AccessRestriction)cm.getSetting(Settings.ACCESS));
        this.setStorageFilter((StorageFilter)cm.getSetting(Settings.STORAGE_FILTER));
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx;
    }

    public void clear() {
        IInventory inv = this.getUpgradeable().getInventoryByName("config");
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            inv.func_70299_a(x, ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public void partition() {
        IInventory inv = this.getUpgradeable().getInventoryByName("config");
        IMEInventoryHandler<IAEItemStack> cellInv = this.storageBus.getInternalHandler();
        Object i = new NullIterator();
        if (cellInv != null) {
            IItemList list = cellInv.getAvailableItems(AEApi.instance().storage().createItemList());
            i = list.iterator();
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                ItemStack g = ((IAEItemStack)i.next()).getItemStack();
                g.func_190920_e(1);
                inv.func_70299_a(x, g);
                continue;
            }
            inv.func_70299_a(x, ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }
}

