/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketPartialItem;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.network.PacketFluidMEInventoryUpdate;
import com.thiakil.appliedfluidics.network.PacketHandler;
import com.thiakil.appliedfluidics.util.FluidPlatform;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerMEMonitorableFluid
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject {
    private final SlotRestrictedInput[] cellView = new SlotRestrictedInput[5];
    private final IMEMonitor<IAEFluidStack> monitorFluids;
    private final IItemList<IAEFluidStack> items = AEApi.instance().storage().createFluidList();
    private final IConfigManager clientCM;
    private final ITerminalHost host;
    @GuiSync(value=99)
    public boolean canAccessViewCells = false;
    @GuiSync(value=98)
    public boolean hasPower = false;
    private IConfigManagerHost gui;
    private IConfigManager serverCM;
    private IGridNode networkNode;
    private IAEFluidStack clientRequestedTargetFluid = null;
    private final List<PacketPartialItem> dataChunks = new LinkedList<PacketPartialItem>();
    private final FluidListener fluidListener = new FluidListener(this);

    public ContainerMEMonitorableFluid(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected ContainerMEMonitorableFluid(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable instanceof TileEntity ? (TileEntity)monitorable : null, monitorable instanceof IPart ? (IPart)monitorable : null);
        this.host = monitorable;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            this.monitorFluids = monitorable.getFluidInventory();
            if (this.monitorFluids != null) {
                IGridNode node;
                this.monitorFluids.addListener((IMEMonitorHandlerReceiver)this.fluidListener, null);
                if (monitorable instanceof IPortableCell) {
                    this.setPowerSource((IEnergySource)monitorable);
                } else if (monitorable instanceof IMEChest) {
                    this.setPowerSource((IEnergySource)monitorable);
                } else if (monitorable instanceof IGridHost && (node = ((IGridHost)monitorable).getGridNode(AEPartLocation.INTERNAL)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitorFluids = null;
        }
        this.canAccessViewCells = false;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, ((IViewCellStorage)monitorable).getViewCellStorage(), y, 206, y * 18 + 8, this.getInventoryPlayer());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.func_75146_a((Slot)this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.monitorFluids != this.host.getFluidInventory()) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (IContainerListener crafter : this.field_75149_d) {
                    if (!(crafter instanceof EntityPlayerMP)) continue;
                    try {
                        NetworkHandler.instance().sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                }
            }
            if (!this.items.isEmpty()) {
                IItemList monitorCache = this.monitorFluids.getStorageList();
                PacketFluidMEInventoryUpdate piu = new PacketFluidMEInventoryUpdate();
                for (IAEFluidStack is : this.items) {
                    IAEFluidStack send = (IAEFluidStack)monitorCache.findPrecise((IAEStack)is);
                    if (send == null) {
                        is.setStackSize(0L);
                        piu.appendItem(is);
                        continue;
                    }
                    piu.appendItem(send);
                }
                if (!piu.isEmpty()) {
                    this.items.resetStatus();
                    for (Object c : this.field_75149_d) {
                        if (!(c instanceof EntityPlayer)) continue;
                        PacketHandler.INSTANCE.sendTo((IMessage)piu, (EntityPlayerMP)c);
                    }
                }
            }
            this.updatePowerStatus();
            boolean oldAccessible = this.canAccessViewCells;
            this.canAccessViewCells = this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldAccessible) {
                for (int y = 0; y < 5; ++y) {
                    if (this.cellView[y] == null) continue;
                    this.cellView[y].setAllowEdit(this.canAccessViewCells);
                }
            }
            super.func_75142_b();
        }
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void func_75132_a(IContainerListener c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    private void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitorFluids != null) {
            PacketFluidMEInventoryUpdate piu = new PacketFluidMEInventoryUpdate();
            IItemList monitorCache = this.monitorFluids.getStorageList();
            for (IAEFluidStack send : monitorCache) {
                piu.appendItem(send);
            }
            PacketHandler.INSTANCE.sendTo((IMessage)piu, (EntityPlayerMP)c);
        }
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitorFluids != null) {
            this.monitorFluids.removeListener((IMEMonitorHandlerReceiver)this.fluidListener);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitorFluids != null) {
            this.monitorFluids.removeListener((IMEMonitorHandlerReceiver)this.fluidListener);
        }
    }

    private void updateHandAndPlaySound(@Nonnull EntityPlayerMP player, boolean filled, boolean drained, Fluid fluid, IFluidHandlerItem playerItemHandler) {
        ItemStack playerItem = player.field_71071_by.func_70445_o();
        player.field_71071_by.func_70437_b(playerItemHandler.getContainer());
        player.func_71113_k();
        this.queueInventory((IContainerListener)player);
        if (fluid != null && (filled || drained)) {
            FluidPlatform.playFluidSoundToUser(player, fluid, filled);
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        IFluidHandlerItem playerItemHandler;
        ItemStack playerItem = player.field_71071_by.func_70445_o();
        IAEFluidStack targetStack = this.getTargetFluidStack();
        if (!playerItem.func_190926_b() && (playerItemHandler = FluidUtil.getFluidHandler((ItemStack)playerItem)) != null) {
            FluidStack playerContained;
            PlayerSource actionSrc = new PlayerSource((EntityPlayer)player, this.getActionHost());
            if (targetStack != null && targetStack.getStackSize() == 0L && targetStack.getCountRequestable() > 0L) {
                targetStack = (IAEFluidStack)targetStack.setStackSize(targetStack.getCountRequestable());
            }
            if ((playerContained = playerItemHandler.drain(Integer.MAX_VALUE, false)) == null && targetStack != null) {
                FluidicsMod.logger.debug("Try to fill container with {}", (Object)targetStack.toString());
                int fillable = playerItemHandler.fill(targetStack.getFluidStack(), false);
                if (fillable == 0) {
                    FluidicsMod.logger.debug("No can fill");
                    return;
                }
                IAEFluidStack request = (IAEFluidStack)targetStack.copy().setStackSize((long)fillable);
                IAEFluidStack extractable = (IAEFluidStack)this.monitorFluids.extractItems((IAEStack)request, Actionable.SIMULATE, (BaseActionSource)actionSrc);
                if (extractable == null || extractable.getStackSize() == 0L) {
                    FluidicsMod.logger.debug("No can extract");
                    return;
                }
                FluidicsMod.logger.debug("System will let us extract {}", (Object)extractable);
                IAEFluidStack extracted = FluidPlatform.poweredExtraction(this.getPowerSource(), this.monitorFluids, extractable, (BaseActionSource)actionSrc);
                if (extracted == null || extracted.getStackSize() == 0L) {
                    FluidicsMod.logger.debug("Couldn't extract");
                    return;
                }
                FluidicsMod.logger.debug("Extracted {} from system", (Object)extracted.getStackSize());
                int filled = playerItemHandler.fill(extracted.getFluidStack(), true);
                if ((long)filled != extracted.getStackSize()) {
                    FluidicsMod.logger.debug("Handler rejected {}", (Object)(extracted.getStackSize() - (long)filled));
                    extracted.decStackSize((long)filled);
                    this.monitorFluids.injectItems((IAEStack)extracted, Actionable.MODULATE, (BaseActionSource)actionSrc);
                    this.updateHandAndPlaySound(player, true, false, extracted.getFluid(), playerItemHandler);
                    return;
                }
                FluidicsMod.logger.debug("All seems good!");
                this.updateHandAndPlaySound(player, true, false, extracted.getFluid(), playerItemHandler);
            } else if (playerContained != null) {
                FluidicsMod.logger.debug("Try to inject " + playerContained.toString());
                NBTAwareAEFluidStack playerAEStack = new NBTAwareAEFluidStack(playerContained);
                IAEFluidStack rejected = (IAEFluidStack)this.monitorFluids.injectItems((IAEStack)playerAEStack, Actionable.SIMULATE, (BaseActionSource)actionSrc);
                int rejectedInt = rejected == null ? 0 : (int)rejected.getStackSize();
                FluidicsMod.logger.debug("System will reject {}", (Object)rejectedInt);
                if (rejectedInt == playerContained.amount) {
                    return;
                }
                FluidStack extracted = playerItemHandler.drain(playerContained.amount - rejectedInt, true);
                if (extracted == null || extracted.amount == 0) {
                    FluidicsMod.logger.debug("Handler didnt give us anything");
                    return;
                }
                rejected = FluidPlatform.poweredInsert(this.getPowerSource(), this.monitorFluids, new NBTAwareAEFluidStack(extracted), (BaseActionSource)actionSrc);
                if (rejected != null && rejected.getStackSize() > 0L) {
                    FluidicsMod.logger.debug("System rejected {}", (Object)rejected.getStackSize());
                    playerItemHandler.fill(rejected.getFluidStack(), true);
                    this.updateHandAndPlaySound(player, false, true, playerContained.getFluid(), playerItemHandler);
                    return;
                }
                FluidicsMod.logger.debug("All seems good!");
                this.updateHandAndPlaySound(player, false, true, playerContained.getFluid(), playerItemHandler);
            }
        }
        super.doAction(player, action, slot, id);
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.cellView.length];
        for (int x = 0; x < this.cellView.length; ++x) {
            list[x] = this.cellView[x].func_75211_c();
        }
        return list;
    }

    public void postPartial(PacketPartialItem packetPartialItem) {
        this.dataChunks.add(packetPartialItem);
        if (packetPartialItem.getPageCount() == this.dataChunks.size()) {
            this.parsePartials();
        }
    }

    private void parsePartials() {
        int total = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            total += ppi.getSize();
        }
        byte[] buffer = new byte[total];
        int cursor = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            cursor = ppi.write(buffer, cursor);
        }
        try {
            NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(buffer));
            if (data != null) {
                this.setTargetFluidStack(NBTAwareAEFluidStack.loadFromNBT(data));
            }
        }
        catch (IOException e) {
            AELog.debug((Throwable)e);
        }
        this.dataChunks.clear();
    }

    public IAEFluidStack getTargetFluidStack() {
        return this.clientRequestedTargetFluid;
    }

    public void setTargetFluidStack(IAEFluidStack stack) {
        if (Platform.isClient()) {
            if (this.clientRequestedTargetFluid != null && this.clientRequestedTargetFluid.equals(stack)) {
                return;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            NBTTagCompound item = new NBTTagCompound();
            if (stack != null) {
                stack.writeToNBT(item);
            }
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)item, (OutputStream)stream);
                int maxChunkSize = 30000;
                LinkedList<byte[]> miniPackets = new LinkedList<byte[]>();
                byte[] data = stream.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(data, 0, stream.size());
                while (bis.available() > 0) {
                    int nextBLock = bis.available() > 30000 ? 30000 : bis.available();
                    byte[] nextSegment = new byte[nextBLock];
                    bis.read(nextSegment);
                    miniPackets.add(nextSegment);
                }
                bis.close();
                stream.close();
                int page = 0;
                for (byte[] packet : miniPackets) {
                    PacketPartialItem ppi = new PacketPartialItem(page, miniPackets.size(), packet);
                    ++page;
                    NetworkHandler.instance().sendToServer((AppEngPacket)ppi);
                }
            }
            catch (IOException e) {
                AELog.debug((Throwable)e);
                return;
            }
        }
        this.clientRequestedTargetFluid = stack == null ? null : stack.copy();
    }

    public SlotRestrictedInput getCellViewSlot(int index) {
        return this.cellView[index];
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    private class FluidListener
    implements IMEMonitorHandlerReceiver<IAEFluidStack> {
        private ContainerMEMonitorableFluid parent;

        public FluidListener(ContainerMEMonitorableFluid p) {
            this.parent = p;
        }

        public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource source) {
            for (IAEFluidStack is : change) {
                this.parent.items.add((IAEStack)is);
            }
            this.onListUpdate();
        }

        public void onListUpdate() {
            for (IContainerListener c : this.parent.field_75149_d) {
                this.parent.queueInventory(c);
            }
        }

        public boolean isValid(Object verificationToken) {
            return true;
        }
    }
}

