/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.handlers;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.IGridVisitor;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IReadOnlyCollection;
import appeng.util.ReadOnlyCollection;
import com.thiakil.appliedfluidics.handlers.IFluidDropGridProxy;
import com.thiakil.appliedfluidics.item.ItemFluidDrop;
import com.thiakil.appliedfluidics.util.FluidDropWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class FluidDropGridProxy
implements IFluidDropGridProxy,
ICellProvider,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    private IStorageGrid storageGrid;
    private ICraftingGrid craftingGrid;
    private final IGrid grid;
    private FluidDropWrapper dropWrapper;
    private Map<Fluid, Integer> pendingIncreases = new HashMap<Fluid, Integer>();
    private boolean addedNode = false;

    public FluidDropGridProxy(IGrid grid) {
        this.grid = grid;
    }

    @MENetworkEventSubscribe
    public void afterCacheConstruction(MENetworkPostCacheConstruction cacheConstruction) {
        this.storageGrid = (IStorageGrid)this.grid.getCache(IStorageGrid.class);
        this.craftingGrid = (ICraftingGrid)this.grid.getCache(ICraftingGrid.class);
        this.storageGrid.registerCellProvider((ICellProvider)this);
        this.dropWrapper = new FluidDropWrapper((IMEInventoryHandler<IAEFluidStack>)this.storageGrid.getFluidInventory(), (IEnergySource)this.grid.getCache(IEnergyGrid.class), true);
        this.storageGrid.getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, (Object)this);
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>(1);
        if (channel == StorageChannel.ITEMS && this.dropWrapper != null) {
            list.add(this.dropWrapper);
        }
        return list;
    }

    public int getPriority() {
        return 0;
    }

    public void onUpdateTick() {
        if (!this.addedNode) {
            FakeGridNode node = new FakeGridNode();
            this.craftingGrid.addNode((IGridNode)node, (IGridHost)node);
            this.addedNode = true;
        }
        this.dropWrapper.processPendingRequests((IMEInventoryHandler<IAEItemStack>)this.storageGrid.getItemInventory());
    }

    public void removeNode(IGridNode gridNode, IGridHost machine) {
    }

    public void addNode(IGridNode gridNode, IGridHost machine) {
    }

    public void onSplit(IGridStorage destinationStorage) {
    }

    public void onJoin(IGridStorage sourceStorage) {
    }

    public void populateGridStorage(IGridStorage destinationStorage) {
    }

    public boolean isValid(Object verificationToken) {
        return verificationToken == this;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        ArrayList<IAEStack> changedDrops = new ArrayList<IAEStack>();
        for (IAEFluidStack changedStack : change) {
            long changedAmount = changedStack.getStackSize() + changedStack.getCountRequestable();
            Fluid changedFluid = changedStack.getFluid();
            if (this.pendingIncreases.containsKey(changedFluid)) {
                changedAmount += (long)this.pendingIncreases.get(changedFluid).intValue();
                this.pendingIncreases.remove(changedFluid);
            }
            if (changedAmount == 0L || changedAmount > 0L && changedAmount < 1000L) {
                if (changedAmount > 0L) {
                    this.pendingIncreases.put(changedFluid, (int)changedAmount);
                }
                return;
            }
            long dropAmount = changedAmount / 1000L;
            if (changedAmount % 1000L != 0L) {
                if (changedAmount < 0L) {
                    --dropAmount;
                } else {
                    this.pendingIncreases.put(changedFluid, (int)changedAmount % 1000);
                }
            }
            if (dropAmount == 0L) continue;
            changedDrops.add(((IAEItemStack)AEApi.instance().storage().createItemStack(ItemFluidDrop.getFilledDrop(changedStack.getFluid())).setStackSize(0L)).setCountRequestable(dropAmount));
        }
        this.storageGrid.postAlterationOfStoredItems(StorageChannel.ITEMS, changedDrops, actionSource);
    }

    public void onListUpdate() {
    }

    private class FakeGridNode
    implements IGridNode,
    IGridHost,
    ICraftingProvider,
    ICraftingWatcherHost {
        private FakeGridNode() {
        }

        public IGridNode getGridNode(AEPartLocation dir) {
            return null;
        }

        public AECableType getCableConnectionType(AEPartLocation dir) {
            return null;
        }

        public void securityBreak() {
        }

        public void beginVisit(IGridVisitor visitor) {
        }

        public void updateState() {
        }

        public IGridHost getMachine() {
            return this;
        }

        public IGrid getGrid() {
            return FluidDropGridProxy.this.grid;
        }

        public void destroy() {
        }

        public World getWorld() {
            return null;
        }

        public EnumSet<AEPartLocation> getConnectedSides() {
            return EnumSet.noneOf(AEPartLocation.class);
        }

        public IReadOnlyCollection<IGridConnection> getConnections() {
            return new ReadOnlyCollection((Collection)Collections.EMPTY_LIST);
        }

        public IGridBlock getGridBlock() {
            return null;
        }

        public boolean isActive() {
            return true;
        }

        public void loadFromNBT(String name, NBTTagCompound nodeData) {
        }

        public void saveToNBT(String name, NBTTagCompound nodeData) {
        }

        public boolean meetsChannelRequirements() {
            return true;
        }

        public boolean hasFlag(GridFlags flag) {
            return false;
        }

        public int getPlayerID() {
            return 0;
        }

        public void setPlayerID(int playerID) {
        }

        public void provideCrafting(ICraftingProviderHelper craftingTracker) {
            FluidDropGridProxy.this.dropWrapper.provideCrafting(craftingTracker);
        }

        public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
            return FluidDropGridProxy.this.dropWrapper.pushPattern(patternDetails, table);
        }

        public boolean isBusy() {
            return FluidDropGridProxy.this.dropWrapper.isBusy();
        }

        public void updateWatcher(ICraftingWatcher newWatcher) {
            FluidDropGridProxy.this.dropWrapper.updateWatcher(newWatcher);
        }

        public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
            FluidDropGridProxy.this.dropWrapper.onRequestChange(craftingGrid, what);
        }
    }
}

