/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.handlers;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.implementations.ContainerCellWorkbench;
import appeng.tile.storage.TileChest;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.handlers.FluidicCellInventory;
import com.thiakil.appliedfluidics.handlers.FluidicCellInventoryHandler;
import com.thiakil.appliedfluidics.handlers.IFluidicCellInventory;
import com.thiakil.appliedfluidics.handlers.IFluidicCellInventoryHandler;
import com.thiakil.appliedfluidics.util.FluidDropWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import sun.reflect.Reflection;

public class FluidicCellHandler
implements ICellHandler {
    public boolean isCell(ItemStack is) {
        return FluidicCellInventory.isCell(is);
    }

    public IMEInventoryHandler getCellInventory(ItemStack is, ISaveProvider container, StorageChannel channel) {
        if (channel == StorageChannel.FLUIDS && !(container instanceof TileChest)) {
            return FluidicCellInventory.getCell(is, container);
        }
        if (container == null) {
            try {
                Class caller = Reflection.getCallerClass((int)3);
                FluidicsMod.logger.debug(caller.getName());
                if (caller.isAssignableFrom(ContainerCellWorkbench.class)) {
                    IMEInventoryHandler<IAEFluidStack> fluidCell = FluidicCellInventory.getCell(is, container);
                    return fluidCell != null ? new FluidDropWrapper(fluidCell, null) : null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void openChestGui(EntityPlayer player, IChestOrDrive chest, ICellHandler cellHandler, IMEInventoryHandler inv, ItemStack is, StorageChannel chan) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("appliedfluidics.chestgui.unsupported", new Object[0]));
    }

    public int getStatusForCell(ItemStack is, IMEInventory handler) {
        if (handler instanceof FluidicCellInventoryHandler) {
            FluidicCellInventoryHandler ci = (FluidicCellInventoryHandler)handler;
            return ci.getStatusForCell();
        }
        return 0;
    }

    public double cellIdleDrain(ItemStack is, IMEInventory handler) {
        IFluidicCellInventory inv = ((IFluidicCellInventoryHandler)handler).getCellInv();
        return inv.getIdleDrain();
    }
}

